/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import java.util.Calendar;
import java.util.Locale;

/**
 * <p>Provides caching for {@link Data} over several requests.</p>
 *
 * <p>The cache doesn't need to provide synchronization; synchronization must be provided
 * from the clients of the cache.</p>
 *
 * <p>The exact caching algorithm is left to the implementation. Memory consumption
 * should be a considered important, as reports may grow quite large.</p>
 */
public interface DataCache {

    /**
     * Adds the specified report data to the cache.
     *
     * @param userId The ID of the user to cache the report for
     * @param path The path of the report
     * @param locale The locale the report was created for
     * @param data The report data to add
     * @param modificationDate The date of the report's last modification
     */
    void put(String userId, String path, Locale locale, Data data,
             Calendar modificationDate);

    /**
     * Gets a report by its path.
     *
     * @param userId The ID of the user to determine the report for
     * @param path The path
     * @param locale The locale the data has to be determined for
     * @param modificationDate The date of the report's last modification
     * @return The cached report; <code>null</code> if the report is not cached
     */
    Data get(String userId, String path, Locale locale, Calendar modificationDate);

}
