/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * This interface represents a "query engine" that is used for retrieving the basic result
 * set. The basic result set is later used for providing grouped and filtered report data.
 */
public interface QueryEngine {

    /**
     * Creates a suitable {@link QueryEngineConfig} object from the given column component
     * node.
     *
     * @param colComponent The column's component node
     * @return The {@link QueryEngineConfig}
     * @throws RepositoryException if creating the config failed due to a repository problem
     */
    QueryEngineConfig createColumnConfig(Node colComponent) throws RepositoryException;

    /**
     * <p>Executes the query for the specified report and builds the given
     * {@link Data} instance accordingly.</p>
     *
     * <p>Note that the report data must be raw (= ungrouped, unfiltered).</p>
     *
     * @param report The report
     * @param data The data object to be filled
     * @param session The session to be used
     * @throws RepositoryException if the query fails due to a repository problem
     */
    void execute(Report report, Data data, Session session) throws RepositoryException;

}
