/*************************************************************************
  *
  * ADOBE CONFIDENTIAL
  * __________________
  *
  *  Copyright 2012 Adobe Systems Incorporated
  *  All Rights Reserved.
  *
  * NOTICE:  All information contained herein is, and remains
  * the property of Adobe Systems Incorporated and its suppliers,
  * if any.  The intellectual and technical concepts contained
  * herein are proprietary to Adobe Systems Incorporated and its
  * suppliers and may be covered by U.S. and Foreign Patents,
  * patents in process, and are protected by trade secret or copyright law.
  * Dissemination of this information or reproduction of this material
  * is strictly forbidden unless prior written permission is obtained
  * from Adobe Systems Incorporated.
  **************************************************************************/
package com.day.cq.wcm.api.components;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

import com.day.cq.wcm.api.WCMMode;

/**
 * The analyze context is used to define the analyze behaviour of components. There is
 * a context opened for every included component that can be analyzed.
 * A component can be analyzed if it provides an analytics definition.
 */
public interface AnalyzeContext {

    /**
     * Checks if this is the root analyze context.
     * @return <code>true</code> if this is the root analyze context
     */
    boolean isRoot();

    /**
     * Returns the parent analyze context or <code>null</code> if this context
     * is the root context.
     * @return the parent context or <code>null</code>
     */
    AnalyzeContext getParent();

    /**
     * Returns the root analyze context.
     * @return the root analyze context.
     */
    AnalyzeContext getRoot();

    /**
     * Returns the primary component context that is bound to this context.
     * Note that an analyze context can span several component context if components
     * are included that do not need editing.
     *
     * @return the component context.
     */
    ComponentContext getComponentContext();

    /**
     * Returns the primary component for this context.
     * @return the component.
     */
    Component getComponent();

    /**
     * Returns the context attribute for the given name
     * @param name the name of the attribute
     * @return the attribute or <code>null</code> if not defined.
     */
    Object getAttribute(String name);
    
    /**
     * Sets a context attribute with the given name. If the given attribute is
     * <code>null</code> it is removed from the attribute map.
     * @param name the name of the attribute
     * @param value the attribute value
     * @return the old attribute or <code>null</code>
     */
    Object setAttribute(String name, Object value);
    
    /**
     * Includes the html prolog needed for editing
     *
     * @param req  the request
     * @param resp the response
     * @param mode the wcm mode
     * @throws IOException      if an I/O error occurs
     * @throws ServletException if a servlet error occurs
     */
    void includeProlog(SlingHttpServletRequest req,
                       SlingHttpServletResponse resp,
                       WCMMode mode)
            throws IOException, ServletException;

    /**
     * Includes the html epilog of this context into the response.
     *
     * @param req  the request
     * @param resp the response
     * @param mode the wcm mode
     * @throws IOException      if an I/O error occurs
     * @throws ServletException if a servlet error occurs
     */
    void includeEpilog(SlingHttpServletRequest req,
                       SlingHttpServletResponse resp,
                       WCMMode mode)
            throws IOException, ServletException;
    
    
}
