/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device;

import org.apache.commons.collections.Predicate;

/**
 * A predicate to evaluate device groups with.
 */
public interface DeviceGroupPredicate extends Predicate {

    /**
     * Evaluates the given {@link DeviceGroup}.
     *
     * @param group The <code>DeviceGroup</code> to evaluate.
     *
     * @return <code>true</code> if the device group successfully evaluates (matches).
     */
    boolean evaluate(DeviceGroup group);
}
