/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import java.util.List;
import java.util.Set;

import com.day.cq.commons.JSONItem;
import com.day.cq.commons.LabeledResource;

/**
 * A <code>RolloutConfig</code> is a config used by the {@link RolloutManager} to
 * perform a roll-out.
 * It defines the set of {@link LiveAction LiveActions} to be performed upon
 * a given event called {@link RolloutManager.Trigger trigger}.<br>
 * {@link com.day.cq.wcm.msm.api.RolloutConfig Roll-out configuration} can be
 * accessed via RolloutConfigManager or
 * the {@link com.day.cq.wcm.msm.api.LiveRelationship LiveRelationship} they are
 * effective on.<br>
 * RolloutConfig is identified by its {@link #getPath() Path}
 *
 * @since 5.4
 * @see LiveRelationship
 */
public interface RolloutConfig extends LabeledResource, JSONItem {

    /**
     * Returns the {@link RolloutManager.Trigger}
     * linked to the current <code>RolloutConfing</code>.
     * @return the trigger
     */
    public RolloutManager.Trigger getTrigger();

    /**
     * The LiveActions to be executed upon a Roll-out.
     * The List is in the order the LiveActions are executed
     * @return configured actions
     * @since 5.5
     */
    public List<LiveAction> getActions();

    //------------------------------------------------< deprecated >------------
    /**
     * Returns a set of the {@link ActionConfig}
     * linked to the current <code>RolloutConfing</code>.
     * @return the actions or an empty set
     * @deprecated since 5.5 use {@link #getActions() getActions()} instead
     */
    @Deprecated
    public Set<ActionConfig> getActionsConfig();
}
