package com.day.cq.wcm.undo;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
AdobePatentID="2789US01"
*/

/**
 * Provides means to manage binary values for the CQ5 undo.
 */
public interface BinaryValueManager {

    /**
     * <p>Checks if the binary value (located at the specified sub-path of the specified
     * paragraph) has changed in relation to the specified original undo data.</p>
     *
     * @param par The paragraph
     * @param subPath The sub-path of the binary data
     * @param originalRef The reference to the original binary data (as returned by a
     *                    previous call to {@link #save})
     * @return <code>true</code> if the binary data has changed
     * @throws BinaryHandlingException if the check could not be executed
     */
    boolean isChanged(Resource par, String subPath, String originalRef)
            throws BinaryHandlingException;

    /**
     * <p>Saves the binary value at the specified repository path to the undo area.</p>
     *
     * @param par The paragraph
     * @param subPath The sub-path of the binary data
     * @return The path of the binary value
     * @throws BinaryHandlingException if the binary resource could not be saved for undo
     *                                 purposes
     */
    String save(Resource par, String subPath) throws BinaryHandlingException;

    /**
     * <p>Restores a binary value from the undo area to a specific content path.</p>
     *
     * @param undoData The binary value used for restoring ("source")
     * @param par The paragraph to restore to
     * @param subPath The sub-path the binary value will be restored to
     * @throws BinaryHandlingException if the binary value could not be restored
     */
    void restore(Resource undoData, Resource par, String subPath)
            throws BinaryHandlingException;

    /**
     * <p>Deletes a binary value from the specified target path.</p>
     *
     * @param par The paragraph
     * @param subPath The sub-path of the binary
     * @param deletePar <code>true</code> to delete the entire paragraph; <code>false</code>
     *                  to delete the BLOB node only
     * @throws BinaryHandlingException if the binary value could not be removed
     */
    void delete(Resource par, String subPath, boolean deletePar)
            throws BinaryHandlingException;

    /**
     * <p>Deletes a binary value from the specified target path.</p>
     *
     * @param resolver The resource resolver to be used for accessing the repository
     * @param undoPath The path to delete from (as, for example returned by {@link #save})
     * @throws BinaryHandlingException if the binary value could not be removed
     */
    void delete(ResourceResolver resolver, String undoPath) throws BinaryHandlingException;

}
