/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;

/**
 * The <code>ParticipantChooserNew</code> interface is intended for impls that
 * will define the participant dynamically.
 * 
 * This interface replaces the deprecated {@link ParticipantChooser} interface.
 * 
 * @see ParticipantChooser
 * 
 * @since 5.4
 */
public interface ParticipantStepChooser {

    /** Constant denoting the name of the label service property. Value = {@value} */
    public static final String SERVICE_PROPERTY_LABEL = "chooser.label";

    /**
     * Returns the dynamically resolved {@link java.security.Principal} id
     * 
     * @param workItem
     *            Current workitem
     * @param workflowSession
     *            Workflow session
     * @param args
     *            Participant chooser specific arguments can be passed here
     * 
     * @return the dynamically resolved {@link java.security.Principal} id
     *
     * @throws WorkflowException When an error is generated
     */
    String getParticipant(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args)
            throws WorkflowException;
}
