/*
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.util.diff;

/**
 * Listener that is called for each line in a document.
 * See {@link DocumentDiff#showChanges(ChangeListener, int)} for details.
 */
public interface ChangeListener {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    /**
     * Invoked before the iteration over the changes start.
     * @param left the left document
     * @param right the right document
     */
    void onDocumentsStart(Document left, Document right);

    /**
     * Invoked after the iteration over the changes finished.
     * @param left the left document
     * @param right the right document
     */
    void onDocumentsEnd(Document left, Document right);

    /**
     * Invoked before a change starts.
     * @param leftElem the index of the left element of this change.
     * @param leftLen the number of changed left elements.
     * @param rightElem the index of the right element of this change.
     * @param rightLen the number of changed right elements.
     */
    void onChangeStart(int leftElem, int leftLen, int rightElem, int rightLen);

    /**
     * Invoked after a change finished.
     */
    void onChangeEnd();

    /**
     * Invoked for an unmodified element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onUnmodified(int leftIdx, int rightIdx, Document.Element elem);

    /**
     * Invoked for a deleted element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onDeleted(int leftIdx, int rightIdx, Document.Element elem);

    /**
     * Invoked for an inserted element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onInserted(int leftIdx, int rightIdx, Document.Element elem);

}
