/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.api;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ResourceResolver;

import java.util.List;

/**
 * Provides an interface to setup synchronization of DAM Folder.
 */
@ProviderType
public interface DAMSyncService {

    /**
     * Registers a new DAM folder from this instance to be synced with Adobe Marketing Cloud.
     *
     * @param folderPath the folder path
     * @param resolver Resource Resolver instance
     */
    public void registerDAMFolder(String folderPath, ResourceResolver resolver);

    /**
     * Replicates resources from this instance to media portal instance
     * @param resourcePaths
     * @param resolver
     */
    public void publishResourcesToMP(List<String> resourcePaths, ResourceResolver resolver);

    /**
     * Unpublish resources from media portal instance
     * @param resourcePaths
     * @param resolver
     */
    public void unpublishResourcesFromMP(List<String> resourcePaths, ResourceResolver resolver);

    /**
     * Unregisters a DAM folder from this instance in order to cancel its synchronisation with Adobe Marketing Cloud.
     *
     * @param folderPath the folder path
     * @param resolver Resource Resolver instance
     */
    public void unregisterDAMFolder(String folderPath, ResourceResolver resolver);
    
    /**
     * Checks if resource is shared across system.
     *
     * @param resourcePath the resource at path to be checked
     * @return true, if asset is shared
     */
    public boolean isMACSharedResource(String resourcePath);

    /**
     * Unpublish AEM Author deleted resources from media portal instance
     * @param resourcePaths
     * @param resolver
     */
    public void unpublishDeletedAssets(List<String> resourcePaths, ResourceResolver resolver);
    
}
