/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.gfx;

import java.io.InputStream;

import org.apache.sling.api.resource.ResourceResolver;

import aQute.bnd.annotation.ConsumerType;

/**
 * SPI interface for providing implementations for the {@link Gfx} API.
 */
@ConsumerType
public interface Renderer {

    /**
     * Renders the given plan and returns a binary file stream, typically an
     * image file format, depending on the plan.
     *
     * <p>
     * Validation and errors:
     * <ul>
     *     <li>
     *          If the plan cannot be rendered (e.g. unsupported operations or unsupported src references),
     *          return null. There should be a validation check at the beginning.
     *     </li>
     *     <li>
     *          If the plan can be rendered, but there is an exception, it should be thrown.
     *     </li>
     * </ul>
     *
     * @param plan describes the rendering operations
     * @param resolver a resource resolver to access files referenced in the plan
     * @return A binary file stream, typically an image file format.
     *         If the plan cannot be rendered, return <code>null</code>.
     * @throws java.lang.Exception if the rendering unexpectedly fails
     */
    InputStream render(Plan plan, ResourceResolver resolver) throws Exception;
}
