/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.api;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * An interface providing methods that are capable of mapping resource paths in the repository to and from resource
 * paths in the HTTP APIs URI space.  One mapper is allowed per category.
 */
@ProviderType
public interface ModelPathMapper {

    /**
     * Converts a resource path to a path in the API space. For example in assets jcr:content is removed from the URL
     * in certain places this adds it back.
     * 
     * <pre>
     * String path = resourcePath;
     * if (path != null &amp;&amp; path.matches(&quot;.*?/jcr:content/(associated|model|variations).*&quot;)) {
     *     path = path.replaceFirst(&quot;jcr:content/((associated|model|variations)&quot;, &quot;$1&quot;);
     *     return path;
     * }
     * </pre>
     * @param resourcePath the resource path to map
     * @return the mapped resource path
     */
    @Nonnull
    String map(final String resourcePath);

    /**
     * Converts an API path to a path in the content space. For example in assets jcr:content is added back to the URL
     * under certain paths:
     * 
     * <pre>
     * String path = apiPath;
     * if (path != null &amp;&amp; path.matches(&quot;.*?/(associated|model|variations).*&quot;)) {
     *     return path.replaceFirst(&quot;(associated|model|variations)&quot;, &quot;jcr:content/$1&quot;);
     * }
     * return path;
     * </pre>
     * @param apiPath the api path to unmap
     * @return the unmapped api path
     */
    @Nonnull
    String unmap(final String apiPath);

}
