/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.license;

import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.Version;

/**
 * Encapsulates information of a product or project.
 * @deprecated This interface is deprecated without a replacement
 */
@Deprecated
@ConsumerType
public interface ProductInfo {

    /**
     * Returns the product name
     *
     * @return the product name.
     */
    String getName();

    /**
     * Returns the product version. e.g. "2020.09.1"
     *
     * @return the product version.
     */
    Version getVersion();

    /**
     * Returns the short product name, e.g. "AEM"
     *
     * @return the short product name
     */
    String getShortName();

    /**
     * Returns the short, textual version. e.g. "2020.09"
     *
     * @return the short product version.
     */
    String getShortVersion();

    /**
     * Returns the product year. e.g. "2020"
     *
     * @return the product version.
     */
    String getYear();

    /**
     * Returns the vendor. e.g. "Adobe"
     *
     * @return the vendor.
     */
    String getVendor();

    /**
     * Returns the vendor url. e.g. "https://www.adobe.com"
     *
     * @return the vendor url.
     */
    String getVendorUrl();

    /**
     * Returns the product url. e.g. "https://www.adobe.com/aem"
     *
     * @return the product url.
     */
    String getUrl();

    /**
     * Returns all properties of this info.
     *
     * @return all properties.
     */
    ValueMap getProperties();
}