/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.socketio;

import java.io.IOException;

import javax.annotation.Nonnull;

import org.apache.sling.commons.json.JSONArray;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Socket.IO ack is used to signal the {@link com.adobe.granite.socketio.SocketIOSocketListener} when the client
 * requests and ack packet.
 */
@ProviderType
public interface SocketIOAck {

    /**
     * Checks if this ack is already handled.
     * @return {@code true} if ack was sent, {@code false} otherwise.
     */
    boolean isAcknowledged();

    /**
     * Sends the ack data back to the client.
     *
     * @param arguments ack data.
     * @throws java.io.IOException if an error occurs
     */
    void send(@Nonnull Object ... arguments) throws IOException;

    /**
     * Sends the ack data back to the client.
     *
     * @param arguments ack data.
     * @throws java.io.IOException if an error occurs
     */
    void send(@Nonnull JSONArray arguments) throws IOException;


}