/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.socketio;

import java.util.Map;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The socket.io service is the entry point to interact with socket.io and is registered as OSGi service.
 */
@ProviderType
public interface SocketIOService {

    /**
     * Returns a map of all used namespaces.
     * @return namespaces map.
     */
    @Nonnull
    Map<String, SocketIONamespace> getNamespaces();

    /**
     * Registers a socket.io listener.
     * @param listener listener to register
     */
    void register(@Nonnull SocketIOListener listener);

    /**
     * Unregisters a socket.io listener
     * @param listener listener to unregister.
     */
    void unregister(@Nonnull SocketIOListener listener);

}