/* ****************************************************************************
*
*	File: SecurityLockPKIInterface.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2006 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import java.util.Map;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.securityframework.pki.Identities;

/**
 * This is a Security Lock factory that 
 * can be used to instantiate different varieties of the password-based Security Locks.</P>
 * <P><B>Note</B>: When the abstract methods declared in this class are implemented
 * by the user, they will be contained in the objects that <code>newInstance()</code> methods return. </P>
 * @author itenenbo
 */
public interface SecurityLockPKIInterface extends SecurityLock 
{
	/**
	 * <P>Create a Security Lock object for encryption 
	 * </P>
	 * @param encryptParams Encryption Parameters Map.
	 * @return a Security Lock object for encryption.
	 * @throws PDFSecurityException 
	 */
	abstract public SecurityLockPKIInterface makeSecurityLock(Map encryptParams, SecurityProvidersImpl providers) 
    throws PDFSecurityException;
	
	
	/**
	 * <P>Builds the recipients, which has the encrypted enveloped data packet.
	 * This enveloped data packet is encrypted using the identities and encrypt parameters.
	 * Returns encrypted enveloped data packet, which contains all the information 
	 * like algorithms used and encrypted data.
	 * </P> 
	 * @param filterName
	 * @param recipients
	 * @param inCrypt
	 * @param encryptParams
	 * @return byte[]
	 * @throws PDFSecurityException
	 */
	abstract public byte[] buildRecipients(String filterName, Identities recipients, boolean inCrypt, Map encryptParams)
    throws PDFSecurityException;
	
}
