/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

import com.adobe.xfa.ut.StringUtils;

/**
 * Implements the W3C DOM ProcessingInstruction interface, wrapping an
 * XFA DOM processing instruction.
 * @exclude from published api.
 */
class ProcessingInstructionImpl extends XFANodeHolder implements ProcessingInstruction {
	private final com.adobe.xfa.ProcessingInstruction mPI;

	ProcessingInstructionImpl (ParentNode parent, com.adobe.xfa.ProcessingInstruction newPI) {
		super (parent, newPI);
		mPI = newPI;
//		debugInit ("Processing instruction");
//		debug ("created");
	}

	public String getData() {
		return mPI.getData();
	}

	public String getTarget() {
		return mPI.getName();
	}

	public void setData(String data) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public String getNodeName() {
		return mPI.getName();
	}

	public short getNodeType() {
		return PROCESSING_INSTRUCTION_NODE;
	}

	public String getNodeValue() throws DOMException {
		return mPI.getData();
	}

	public String getTextContent() throws DOMException {
		return mPI.getData();
	}

	public boolean isEqualNode(Node other) {
		if (this == other) {
			return true;
		}
		if (! (other instanceof ProcessingInstructionImpl)) {
			return false;
		}
		ProcessingInstructionImpl otherPI = (ProcessingInstructionImpl) other;
		return StringUtils.equalsWithNull (mPI.getName(), otherPI.mPI.getName())
			&& StringUtils.equalsWithNull (mPI.getData(), otherPI.mPI.getData());
	}
}
