package com.adobe.xfa.gfx;

/**
 * @exclude from published api.
 */

public class GFXFillAttr extends GFXAttr {
	public final static GFXFillAttr BLACK_FILL = new GFXFillAttr (GFXAttr.STYLE_SOLID, GFXAttr.DEFAULT_SHADESCALE, GFXColour.BLACK, GFXColour.BLACK);
	public final static GFXFillAttr WHITE_FILL = new GFXFillAttr (GFXAttr.STYLE_SOLID, GFXAttr.DEFAULT_SHADESCALE, GFXColour.WHITE, GFXColour.WHITE);
	public final static GFXFillAttr LIGHTGRAY_FILL = new GFXFillAttr (GFXAttr.STYLE_SOLID, GFXAttr.DEFAULT_SHADESCALE, GFXColour.LIGHTGRAY, GFXColour.LIGHTGRAY);
	public final static GFXFillAttr GRAY_FILL = new GFXFillAttr (GFXFillAttr.STYLE_SOLID, GFXAttr.DEFAULT_SHADESCALE, GFXColour.GRAY, GFXColour.GRAY);
	public final static GFXFillAttr DARKGREY_FILL = new GFXFillAttr (GFXAttr.STYLE_SOLID, GFXAttr.DEFAULT_SHADESCALE, GFXColour.DARKGRAY, GFXColour.DARKGRAY);
	public final static GFXFillAttr NO_FILL = new GFXFillAttr (GFXAttr.STYLE_NONE, GFXAttr.DEFAULT_SHADESCALE, GFXColour.BLACK, GFXColour.BLACK);

/**
 * Default constructor.
 * <p>
 * Creates a new Fill attribute with default settings.
 */
	public GFXFillAttr () {
	}

/**
 * Copy constructor.
 * <p>
 * Creates a new Fill attribute with the same settings
 * as the source attribute.
 * @param oSource - Fill attribute to copy
 */
	public GFXFillAttr (GFXFillAttr oSource) {
		copyFrom (oSource);
	}

/**
 * Constructor.
 * <p>
 * Creates a new Fill attribute with the specified settings.
 * @param nNewStyle - The style setting for this attribute
 * @param lNewShade - The shade setting for this attribute
 * @param oNewColour - The foreground colour to be used
 * @param oNewColourBg - The background colour to be used
 */
	public GFXFillAttr (int nNewStyle, int lNewShade, GFXColour oNewColour, GFXColour oNewColourBg) {
		super (nNewStyle, lNewShade, oNewColour, oNewColourBg);
	}

/**
 * Get a default Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = white
 *	 Background colour = white
 * </pre>
 * @return A Fill Attribute with default settings
 */
	public static GFXFillAttr defaultFill () {
		return WHITE_FILL;
	}

/**
 * Get a black filled Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = black
 *	 Background colour = black
 * </pre>
 * @return A Fill Attribute with Black fill settings
 */
	public static GFXFillAttr blackFill () {
		return BLACK_FILL;
	}

/**
 * Get a white filled Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = white
 *	 Background colour = white
 * </pre>
 * @return A Fill Attribute with White fill settings
 */
	public static GFXFillAttr whiteFill () {
		return WHITE_FILL;
	}

/**
 * Get a light gray filled Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = light gray
 *	 Background colour = light gray
 * </pre>
 * @return A Fill Attribute with Light Gray fill settings
 */
	public static GFXFillAttr lightGrayFill () {
		return LIGHTGRAY_FILL;
	}

/**
 * Get a gray filled Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = gray
 *	 Background colour = gray
 * </pre>
 * @return A Fill Attribute with Gray fill settings
 */
	public static GFXFillAttr grayFill () {
		return GRAY_FILL;
	}

/**
 * Get a dark gray filled Fill Attribute.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = solid
 *	 Shade scale	   = maximum
 *	 Foreground colour = dark gray
 *	 Background colour = dark gray
 * </pre>
 * @return A Fill Attribute with Dark Gray fill settings
 */
	public static GFXFillAttr darkGrayFill () {
		return DARKGREY_FILL;
	}

/**
 * Get a Fill Attribute with no fill.
 * <p>
 * This will return a Fill Attribute with the following settings:
 * <pre>
 *	 Style			   = none
 *	 Shade scale	   = maximum
 *	 Foreground colour = black
 *	 Background colour = black
 * </pre>
 * @return A Fill Attribute with no fill settings
 */
	public static GFXFillAttr noFill () {
		return NO_FILL;
	}

/**
 * Equality comparison.
 * <p>
 * Compares on an attribute value basis. Two attributes are
 * considered equal if their values compare for equality.
 * @param oCompare - Attribute object to compare against.
 * @return TRUE if all members are equal, FALSE otherwise.
 */
// Javaport: not needed when method merely calls super.
//	public boolean equivalent (GFXFillAttr oCompare) {
//		return super.equivalent (oCompare);
//	}

/**
 * Equality comparison operator.
 * <p>
 * Compares on an attribute value basis. Two attributes are
 * considered equal if their values compare for equality.
 * @param oCompare - Attribute object to compare against.
 * @return TRUE if the attribute objects are considered equal;
 * FALSE otherwise.
 */
// Javaport: not needed when method merely calls super.
//	public boolean equals (Object oCompare) {
//		return super.equals (oCompare);
//	}

/**
 * Assigment operator.
 * <p>
 * Replace all attribute settings with those from the source object.
 * @param oSource - Source attribute object to copy.
 */
	public void copyFrom (GFXFillAttr oSource) {
		if (this != oSource) {
			super.copyFrom (oSource);
		}
	}
}
