/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;


/**
 * An abstract base class for XFA exceptions.
 *
 * <p> Objects of this class have an associated boolean WasReported property.
 * As architected, this property can be used by the derived classes to mean
 * anything. </p>
 */
public abstract class ExceptionBase extends RuntimeException {
	
	private static final long serialVersionUID = -687536745161985131L;

	private boolean  mbWasReported;				// the WasReported property.

	/**
	 * Instantiate a exception object.
	 *
	 * @exclude from published api.
	 */
	public ExceptionBase() {
		//mbWasReported = false;
	}

	/**
	 * Instantiate a exception object -- the boolean c'tor.
	 * @param bWasReported set this object's WasReported property
	 * to the given boolean.
	 *
	 * @exclude from published api.
	 */
	public ExceptionBase(boolean bWasReported) {
		mbWasReported = bWasReported;
	}

	/**
	 * Resolves the exception objects
	 * in the derived class's collection.
	 */
	public abstract void resolve();

	/**
	 * Counts the number of exception
	 * objects in the derived class's collection.
	 * @return the count.
	 */
	public abstract int count();

	/**
	 * Pure abstract indexing operator to reference
	 * the given <i>n</i>'th exception object in the derived class's
	 * collection.
	 * @param n the index of the exception object to return. 
	 * Must be in the range 0 to count() - 1.
	 * @return the <i>n</i>'th exception object.
	 *
	 * @exclude from published api.
	 */
	public abstract ExErrItem item(int n);

	/**
	 * Get this object's WasReported property.
	 * @return the WasReported property.
	 *
	 * @exclude from published api.
	 */
	public boolean wasReported() {
		return mbWasReported;
	}

	/**
	 * Set this object's WasReported property to the given boolean.
	 * @param bWasReported the new WasReproted property.
	 *
	 * @exclude from published api.
	 */
	public void wasReported( boolean bWasReported) {
		mbWasReported = bWasReported;
	}

}
