/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Locale;

/**
 * A {@code Resolution} enumerates all the possible report resolution from Adobe Target
 */
public enum Resolution {

    HOUR, DAY, WEEK, MONTH;

    public String getTestandTargetKey() {
        return toString().toLowerCase(Locale.ENGLISH);
    }

    public static Resolution fromTestandTargetKey(String testandTargetKey) {
        for (Resolution resolution : Resolution.values())
            if (resolution.getTestandTargetKey().equals(testandTargetKey))
                return resolution;

        return null;
    }
}
