/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.ui.preview;

import java.util.Iterator;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resource.collection.ResourceCollection;

import com.day.cq.dam.api.Asset;

/**
 * Provider that retrieves the assets representing the collection members for a given collection.
 * A provider handles a specific collection type (e.g. a collection of products) and is dynamically registered.
 * {@link CollectionPreviewManager} loops over all the registered providers to find the first that
 * can handle the collection.
 */
@ProviderType
public interface CollectionPreviewProvider {

    /**
     * Returns an <code>Iterator</code> of {@link Asset}s representing the collection members for a given collection.
     * @param resolver The scope's resolver.
     * @param collection The resource collection.
     * @return An {@link Iterator} of {@link Asset}s representing the collection members.
     *          It returns <code>null</code> if the provider cannot handle the collection.
     */
    Iterator<Asset> getCollectionAssets(ResourceResolver resolver, ResourceCollection collection);
}
