/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.UserPropertiesUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Implements the <code>&lt;personalisation:contextProfileLink/&gt;</code> tag AdobePatentID="B1393"
 */
public class ContextProfileLinkTag extends TagSupport {

    private String href;
    private String displayValue;
    private String displayValuePropertyName;
    private String id;
    private String store;
    private String prefix;
    private String suffix;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        href = "";
        displayValue = null;
        displayValuePropertyName = null;
        id = "";
        store = "profile";
        prefix = "";
        suffix = "";
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public void setDisplayValuePropertyName(String displayValuePropertyName) {
        this.displayValuePropertyName = displayValuePropertyName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request, request.adaptTo(UserProperties.class)));

        } catch (IOException e) {
            throw new JspException("Could not write script for context profile link", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request, UserProperties userProperties) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        String value;
        if (StringUtils.isNotBlank(displayValuePropertyName)) {
            value = UserPropertiesUtil.getValue(userProperties, displayValuePropertyName);
        } else {
            value = displayValue;
        }

        StringBuilder res = new StringBuilder();

        res.append("<a id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" href=\"\">").append(xssAPI.encodeForHTML(prefix + value + suffix)).append("</a>");

        res.append("<script type=\"text/javascript\">");
        res.append("$CQ(function() {");
        res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
        res.append("CQ_Analytics.ClientContextUtils.onStoreRegistered('")
                .append(xssAPI.encodeForJSString(store)).append("', function(store) {");
        res.append("var renderer = function() {");
        res.append("var linkHref = '").append(xssAPI.encodeForJSString(href)).append("';");
        res.append("var linkValue = '").append(xssAPI.encodeForJSString(value)).append("';");
        res.append("var p = store.getData();");
        res.append("if (p) {");
        res.append("linkHref = linkHref.replace(/\\$\\{profile\\.path\\}/g, p['path']);");
        if (StringUtils.isNotBlank(displayValuePropertyName)) {
            res.append("linkValue = store.getProperty('").append(xssAPI.encodeForJSString(displayValuePropertyName))
                    .append(
                            "') || '';");
        }
        res.append("}");
        res.append("linkValue = '").append(xssAPI.encodeForJSString(prefix)).append("' + linkValue + '").append(
                xssAPI.encodeForJSString(suffix)).append("';");
        res.append("var link = document.getElementById('").append(xssAPI.encodeForJSString(id)).append("');");
        res.append("if (link && link.href != linkHref) {");
        res.append("link.href = '" + request.getContextPath() + "' + linkHref;");
        res.append("}");
        res.append("if (link && link.innerHTML != linkValue) {");
        res.append("link.innerHTML = linkValue;");
        res.append("}");
        res.append("};");
        res.append("renderer();");
        res.append("store.addListener('update', function() {");
        res.append("renderer();");
        res.append("});");
        res.append("});");
        res.append("}");
        res.append("});");
        res.append("</script>");

        return res.toString();
    }
}
