/*
 * Copyright 1997-2012 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.contentfinder;

import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * This index is offering a free text search on node properties.
 * @deprecated Use oak's lucene suggestions instead.
 */
public interface NodeNameIndexer {

    /**
     * @param substring filters out a property map if none of its property contains it
     * @param rootLocation filters out a property map if the indexed node is not a child of it
     * @param nodeTypes filters out a property map if the indexed node is not of any type contained in it
     * @return the list of properties map matching the <code>substring</code>, <code>rootLocation</code> and
     *         <code>nodeTypes</code>
     * @deprecated Use oak's lucene suggestions instead.
     */
    List<Map<String, String>> search(String substring, String rootLocation, String nodeTypes[]);

    /**
     * @param substring filters out a property map if none of its property contains it
     * @param rootLocation filters out a property map if the indexed node is not a child of it
     * @param nodeTypes filters out a property map if the indexed node is not of any type contained in it
     * @param locale filters out a property map if the indexed node locale does not matches it.
     *               if no property map matches the given locale, then the one with the default locale is selected.
     * @return the list of properties map matching the <code>substring</code>, <code>rootLocation</code>,
     *         <code>nodeTypes</code> and <code>locale</code>
     * @deprecated Use oak's lucene suggestions instead.
     */
    List<Map<String, String>> search(String substring, String rootLocation, String nodeTypes[], Locale locale);
}
