/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * A class to define miscellaneous string constants.
 */
public final class STRS {

	/**
	 * The "    " atom.
	 **/
	public static final String INDENT = "   ";
	/**
	 * The "#" atom.
	 **/
	public static final String HASHCHAR = "#";
	/**
	 * The "_" atom.
	 **/
	public static final String UNDERSCORE = "_";
	/**
	 * The "-" atom.
	 **/
	public static final String DASH = "-";
	/**
	 * The ":" atom.
	 **/
	public static final String COLON = ":";
	/**
	 * The ";" atom.
	 **/
	public static final String SEMICOLON = ";";
	/**
	 * The "," atom.
	 **/
	public static final String COMMA = ",";
	/**
	 * The "(" atom.
	 **/
	public static final String LEFTBRACE = "(";
	/**
	 * The ")" atom.
	 **/
	public static final String RIGHTBRACE = ")";
	/**
	 * The "{" atom.
	 **/
	public static final String LEFTCURLBRACE = "{";
	/**
	 * The "}" atom.
	 **/
	public static final String RIGHTCURLBRACE = "}";
	/**
	 * The "0,0,0" atom.
	 **/
	public static final String BLACKCOLOR = "0,0,0";
	/**
	 * The "0pt" atom.
	 **/
	public static final String ZEROPT = "0pt";
	/**
	 * The "10pt" atom.
	 **/
	public static final String TENPT = "10pt";
	/**
	 * The "1000pt" atom.
	 **/
	public static final String THOUSANDPT = "1000pt";
	/**
	 * The "100%" atom.
	 **/
	public static final String HUNDREDPERCENT = "100%";
	/**
	 * The "255,255,255" atom.
	 **/
	public static final String WHITECOLOR = "255,255,255";
	/**
	 * The "%b" atom.
	 **/
	public static final String PERCENTB = "%b";
	/**
	 * The "%s" atom.
	 **/
	public static final String PERCENTS = "%s";
	/**
	 * The "$config" atom.
	 **/
	public static final String DOLLARCONFIG = "$config";
	/**
	 * The "$connectionSet" atom.
	 **/
	public static final String DOLLARCONNECTIONSET = "$connectionSet";
	/**
	 * The "$data" atom.
	 **/
	public static final String DOLLARDATA = "$data";
	/**
	 * The "$form" atom.
	 **/
	public static final String DOLLARFORM = "$form";
	/**
	 * The "$layout" atom.
	 **/
	public static final String DOLLARLAYOUT = "$layout";
	/**
	 * The "$localeSet" atom.
	 **/
	public static final String DOLLARLOCALESET = "$localeSet";
	/**
	 * The "$template" atom.
	 **/
	public static final String DOLLARTEMPLATE = "$template";
	/**
	 * The "$sourceSet" atom.
	 **/
	public static final String DOLLARSOURCESET = "$sourceSet";
	/**
	 * The "$host" atom.
	 **/
	public static final String DOLLARHOST = "$host";
	/**
	 * The "$xdc" atom.
	 **/
	public static final String DOLLARXDC = "$xdc";
	/**
	 * The "$xfa" atom.
	 **/
	public static final String DOLLARXFA = "$xfa";
	/**
	 * The "$log" atom.
	 **/
	public static final String DOLLARLOG = "$log";
	/**
	 * The "$event" atom.
	 **/
	public static final String DOLLAREVENT = "$event";
	/**
	 * The "APIVersion" atom.
	 **/
	public static final String APIVERSION = "APIVersion";
	/**
	 * The "append" atom.
	 **/
	public static final String APPEND = "append";
	/**
	 * The "application/octet-stream" atom.
	 **/
	public static final String APPLICATIONOCTETSTREAM = "application/octet-stream";
	/**
	 * The "body" atom.
	 **/
	public static final String BODY = "body";
	/**
	 * The "bold" atom.
	 **/
	public static final String BOLD = "bold";
	/**
	 * The "BoundColumn" atom.
	 **/
	public static final String BOUNDCOLUMN = "BoundColumn";
	/**
	 * The "ChoiceList" atom.
	 **/
	public static final String CHOICELIST = "ChoiceList";
	/**
	 * The "ColDelimiter" atom.
	 **/
	public static final String COLDELIMITER = "ColDelimiter";
	/**
	 * The "ColumnCount" atom.
	 **/
	public static final String COLUMNCOUNT = "ColumnCount";
	/**
	 * The "contentChildChange" atom.
	 **/
	public static final String CONTENTCHILDCHANGE = "contentChildChange";
	/**
	 * The "contentType" atom.
	 **/
	public static final String CONTENTTYPE = "contentType";
	/**
	 * The "Courier" atom.
	 **/
	public static final String COURIER = "Courier";
	/**
	 * The "Courier Std" atom.
	 **/
	public static final String COURIERSTD = "Courier Std";
	/**
	 * The "Data" atom.
	 **/
	public static final String DATA = "Data";
	/**
	 * The "datasets" atom.
	 **/
	public static final String DATASETS = "datasets";
	/**
	 * The "DataGroup" atom.
	 **/
	public static final String DATAGROUP = "DataGroup";
	/**
	 * The "dataDescription" atom.
	 **/
	public static final String DATADESCRIPTION = "dataDescription";
	/**
	 * The "delta" atom.
	 **/
	public static final String DELTA = "delta";
	/**
	 * The "http://ns.adobe.com/data-description/" atom.
	 **/
	public static final String DATADESCRIPTIONURI = "http://ns.adobe.com/data-description/";
	/**
	 * The "display" atom.
	 **/
	public static final String DISPLAY = "display";
	/**
	 * The "DropDownStyle" atom.
	 **/
	public static final String DROPDOWNSTYLE = "DropDownStyle";
	/**
	 * The "EXTENDED_CodeBase" atom.
	 **/
	public static final String EXTENDEDCODEBASE = "EXTENDED_CodeBase";
	/**
	 * The "formattedFragments" atom.
	 **/
	public static final String FORMATTEDFRAGMENTS = "formattedFragments";
	/**
	 * The "formattedValue" atom.
	 **/
	public static final String FORMATTEDVALUE = "formattedValue";
	/**
	 * The "generator" atom.
	 **/
	public static final String GENERATOR = "generator";
	/**
	 * The "global" atom.
	 **/
	public static final String GLOBAL = "global";
	/**
	 * The "html" atom.
	 **/
	public static final String HTML = "html";
	/**
	 * The "ignore" atom.
	 **/
	public static final String IGNORE = "ignore";
	/**
	 * The "italic" atom.
	 **/
	public static final String ITALIC = "italic";
	/**
	 * The "jetform" atom.
	 **/
	public static final String JETFORM = "jetform";
	/**
	 * The "jfxpf:XPF" atom.
	 **/
	public static final String XPFNAMESPACE = "jfxpf:XPF";
	/**
	 * The "LabelHorizontalJustification" atom.
	 **/
	public static final String LABELHORIZONTALJUSTIFICATION = "LabelHorizontalJustification";
	/**
	 * The "LabelVerticalJustification" atom.
	 **/
	public static final String LABELVERTICALJUSTIFICATION = "LabelVerticalJustification";
	/**
	 * The "layoutNode" atom.
	 **/
	public static final String LAYOUTNODE = "layoutNode";
	/**
	 * The "layoutNodeList" atom.
	 **/
	public static final String LAYOUTNODELIST = "layoutNodeList";
	/**
	 * The "LineSpace" atom.
	 **/
	public static final String LINESPACE = "LineSpace";
	/**
	 * The "LineSpacingPoints" atom.
	 **/
	public static final String LINESPACINGPOINTS = "LineSpacingPoints";
	/**
	 * The "list" atom.
	 **/
	public static final String LIST = "list";
	/**
	 * The "MapIndex" atom.
	 **/
	public static final String MAPINDEX = "MapIndex";
	/**
	 * The "MaxChars" atom.
	 **/
	public static final String MAXCHARS = "MaxChars";
	/**
	 * The "MultiLine" atom.
	 **/
	public static final String MULTILINE = "MultiLine";
	/**
	 * The "many" atom.
	 **/
	public static final String MANY = "many";
	/**
	 * The "nodeList" atom.
	 **/
	public static final String NODELIST = "nodeList";
	/**
	 * The "none" atom.
	 **/
	public static final String NONE = "none";
	/**
	 * The "normal" atom.
	 **/
	public static final String NORMAL = "normal";
	/**
	 * The "once" atom.
	 **/
	public static final String ONCE = "once";
	/**
	 * The "plain" atom.
	 **/
	public static final String PLAIN = "plain";
	/**
	 * The "preserve" atom.
	 **/
	public static final String PRESERVE = "preserve";
	/**
	 * The "RichEdit.dll" atom.
	 **/
	public static final String RICHEDITDLL = "RichEdit.dll";
	/**
	 * The Rich Text xfa-tab-stops attribute name. 
	 */
	public static final String RichText_XFATabStops = "xfa-tab-stops";
	/**
	 * The Rich Text xfa-font-horizontal-scale attribute name.
	 */
	public static final String RichText_XFAHorizontalScale = "xfa-font-horizontal-scale";
	/**
	 * The Rich Text xfa-font-vertical-scale attribute name.
	 */
	public static final String RichText_XFAVerticalScale = "xfa-font-vertical-scale";
	/**
	 * The Rich Text kerning-mode attribute name.
	 */
	public static final String RichText_KerningMode = "kerning-mode";
	/**
	 * The Rich Text letter-spacing attribute name.
	 */
	public static final String RichText_LetterSpacing = "letter-spacing";
	/**
	 * The "RowDelimiter" atom.
	 **/
	public static final String ROWDELIMITER = "RowDelimiter";
	/**
	 * The "rtf" atom.
	 **/
	public static final String RTF = "rtf";
	/**
	 * The "ScrollLabel" atom.
	 **/
	public static final String SCROLLLABEL = "ScrollLabel";
	/**
	 * The "server" atom.
	 */
	public static final String SERVER = "server";
	/**
	 * The "SRGB" atom.
	 **/
	public static final String SRGB = "SRGB";
	/**
	 * The "state" atom.
	 **/
	public static final String STATE = "state";
	/**
	 * The "stringList" atom.
	 **/
	public static final String STRINGLIST = "stringList";
	/**
	 * The "stylesheet" atom.
	 **/
	public static final String STYLESHEET = "stylesheet";
	/**
	 * The "http://www.w3.org/2000/svg" atom.
	 **/
	public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
	/**
	 * The "Text" atom.
	 **/
	public static final String TEXT = "Text";
	/**
	 * The "TextColumn" atom.
	 **/
	public static final String TEXTCOLUMN = "TextColumn";
	/**
	 * The "text/html" atom.
	 **/
	public static final String TEXTHTML = "text/html";
	/**
	 * The "text/plain" atom.
	 **/
	public static final String TEXTPLAIN = "text/plain";
	/**
	 * The "text/xml" atom.
	 **/
	public static final String TEXTXML = "text/xml";
	/**
	 * The "true" atom.
	 **/
	public static final String TRUE = "true";
	/**
	 * The "Type" atom.
	 **/
	public static final String TYPE = "Type";
	/**
	 * The "usePrinterSetting" atom.
	 **/
	public static final String USEPRINTERSETTING = "usePrinterSetting";
	/**
	 * The "useXDCSetting" atom.
	 **/
	public static final String USEXDCSETTING = "useXDCSetting";
	/**
	 * The "Version" atom.
	 **/
	public static final String VERSION = "Version";
	/**
	 * The "xdp:xdp" atom.
	 **/
	public static final String XDPNODE = "xdp:xdp";
	/**
	 * The "http://ns.adobe.com/xdp/" atom.
	 **/
	public static final String XDP_NAMESPACE = "http://ns.adobe.com/xdp/";
	/**
	 * The "xfa:" atom.
	 **/
	public static final String XFANAMESPACE = "xfa:";
	/**
	 * The "xfa:data" atom.
	 **/
	public static final String XFADATA = "xfa:data";
	/**
	 * The "xfa:DataGroup" atom.
	 **/
	public static final String XFADATAGROUP = "xfa:DataGroup";
	/**
	 * The "xfa:dataNode" atom.
	 **/
	public static final String XFADATANODE = "xfa:dataNode";
	/**
	 * The "xfa:merge" atom.
	 **/
	public static final String XFAMERGE = "xfa:merge";
	/**
	 * The "xfa:null" atom.
	 **/
	public static final String XFANULL = "xfa:null";
	/**
	 * The "xfa:datasets" atom.
	 **/
	public static final String XFADATASETS = "xfa:datasets";
	/**
	 * The "xfa.config" atom.
	 **/
	public static final String XFACONFIG = "xfa.config";
	/**
	 * The "xfd" atom.
	 **/
	public static final String XFD = "xfd";
	/**
	 * The "xfdf" atom.
	 **/
	public static final String XFDF = "xfdf";
	/**
	 * The "xhtml" atom.
	 **/
	public static final String XHTML = "xhtml";
	/**
	 * The "http://www.w3.org/1999/xhtml" atom.
	 **/
	public static final String XHTMLNS = "http://www.w3.org/1999/xhtml";
	/**
	 * The "http://ns.adobe.com/xfdf/" atom.
	 **/
	public static final String XFDFNS = "http://ns.adobe.com/xfdf/";
	/**
	 * The "http://ns.adobe.com/xfdf-transition/" atom.
	 **/
	public static final String XFDFTRANSITIONNS = "http://ns.adobe.com/xfdf-transition/";
	/**
	 * The "http://www.xfa.org/schema/xfa-data/" atom.
	 **/
	public static final String XFADATANS = "http://www.xfa.org/schema/xfa-data/";
	/**
	 * The "http://www.xfa.org/schema/xfa-data/1.0/" atom.
	 **/
	public static final String XFADATANS_CURRENT = "http://www.xfa.org/schema/xfa-data/1.0/";
	/**
	 * The "http://www.xfa.com/schema/xfa-data" atom.
	 **/
	public static final String OLDXFADATANS = "http://www.xfa.com/schema/xfa-data";
	/**
	 * The "http://www.xfa.org/schema/xfa-package/" atom.
	 **/
	public static final String XFAPACKAGENS = "http://www.xfa.org/schema/xfa-package/";
	/**
	 * The "http://www.xfa.com/schema/xml-package" atom.
	 **/
	public static final String XMLPACKAGENS = "http://www.xfa.com/schema/xml-package";
	/**
	 * The "http://www.xfa.org/schema/xfa-events/" atom.
	 **/
	public static final String XFAEVENTSNS = "http://www.xfa.org/schema/xfa-events/";
	/**
	 * The "xmpmeta" atom.
	 **/
	public static final String XMPMETA = "xmpmeta";
	/**
	 * The "adobe:ns:meta/" atom.
	 **/
	public static final String XMPMETANS = "adobe:ns:meta/";
	/**
	 * The "http://www.xfa.org/schema/xfa-template/" atom.
	 **/
	public static final String XFATEMPLATENS = "http://www.xfa.org/schema/xfa-template/";
	/**
	 * The "http://www.xfa.org/schema/xfa-template/2.1/" atom.
	 **/
	public static final String XFATEMPLATENS_TWODOTONE = "http://www.xfa.org/schema/xfa-template/2.1/";
	/**
	 * The "http://www.xfa.org/schema/xfa-template/2.2/" atom.
	 **/
	public static final String XFATEMPLATENS_TWODOTTWO = "http://www.xfa.org/schema/xfa-template/2.2/";
	/**
	 * The "http://www.xfa.org/schema/xfa-template/3.5/" atom.
	 **/
	public static final String XFATEMPLATENS_CURRENT = "http://www.xfa.org/schema/xfa-template/3.5/";
	/**
	 * The "http://www.xfa.org/schema/xci/" atom.
	 **/
	public static final String XFACONFIGURATIONNS = "http://www.xfa.org/schema/xci/";
	/**
	 * The "http://www.xfa.org/schema/xci/3.0/" atom.
	 **/
	public static final String XFACONFIGURATIONNS_CURRENT = "http://www.xfa.org/schema/xci/3.0/";
	/**
	 * The "http://www.xfa.org/schema/xfa-source-set/" atom.
	 **/
	public static final String XFASOURCESETNS = "http://www.xfa.org/schema/xfa-source-set/";
	/**
	 * The "http://www.xfa.org/schema/xfa-source-set/2.4/" atom.
	 **/
	public static final String XFASOURCESETNS_CURRENT = "http://www.xfa.org/schema/xfa-source-set/2.8/";
	/**
	 * The "http://www.xfa.org/schema/xfa-connection-set/" atom.
	 **/
	public static final String XFACONNECTIONSETNS = "http://www.xfa.org/schema/xfa-connection-set/";
	/**
	 * The "http://www.xfa.org/schema/xfa-connection-set/2.8/" atom.
	 **/
	public static final String XFACONNECTIONSETNS_CURRENT = "http://www.xfa.org/schema/xfa-connection-set/2.8/";
	/**
	 * The "http://www.xfa.org/schema/xfa-locale-set/" atom.
	 **/
	public static final String XFALOCALESETNS = "http://www.xfa.org/schema/xfa-locale-set/";
	/**
	 * The "http://www.xfa.org/schema/xfa-locale-set/2.7/" atom.
	 **/
	public static final String XFALOCALESETNS_CURRENT = "http://www.xfa.org/schema/xfa-locale-set/2.7/";
	/**
	 * The "http://www.xfa.org/schema/xfa-form/" atom.
	 **/
	public static final String XFAFORMNS = "http://www.xfa.org/schema/xfa-form/";
	/**
	 * The "http://www.xfa.org/schema/xfa-form/2.8/" atom.
	 **/
	public static final String XFAFORMNS_CURRENT = "http://www.xfa.org/schema/xfa-form/2.8/";
	/**
	 * The "nil" atom.
	 **/
	public static final String NIL = "nil";
	/**
	 * The "null" atom.
	 **/
	public static final String NULL = "null";
	/**
	 * The "xsi:nil" atom.
	 **/
	public static final String XSINIL = "xsi:nil";
	/**
	 * The "http://www.w3.org/2001/XMLSchema-instance" atom.
	 **/
	public static final String XSINS = "http://www.w3.org/2001/XMLSchema-instance";
	/**
	 * The "http://www.w3.org/" atom.
	 **/
	public static final String XSINSPREFIX = "http://www.w3.org/";
	/**
	 * The "/XMLSchema-instance" atom.
	 **/
	public static final String XSINSSUFFIX = "/XMLSchema-instance";
	/**
	 * The "urn:oasis:names:tc:xliff:document:1.1" atom.
	 **/
	public static final String XLIFFNS = "urn:oasis:names:tc:xliff:document:1.1";
	/**
	 * The "xliff:" atom.
	 **/
	public static final String XLIFFPREFIX = "xliff:";
	/**
	 * The "letter" page sizes atom.
	 */
	public static final String LETTER = "letter";
	/**
	 * The "letterSmall" page sizes atom.
	 */
	public static final String LETTERSMALL = "letterSmall";
	/**
	 * The "tabloid" page sizes atom.
	 */
	public static final String TABLOID = "tabloid";
	/**
	 * The "ledger" page sizes atom.
	 */
	public static final String LEDGER = "ledger";
	/**
	 * The "legal" page sizes atom.
	 */
	public static final String LEGAL = "legal";
	/**
	 * The "statement" page sizes atom.
	 */
	public static final String STATEMENT = "statement";
	/**
	 * The "executive" page sizes atom.
	 */
	public static final String EXECUTIVE = "executive";
	/**
	 * The "a3" page sizes atom.
	 */
	public static final String A3 = "a3";
	/**
	 * The "a4" page sizes atom.
	 */
	public static final String A4 = "a4";
	/**
	 * The "a4Small" page sizes atom.
	 */
	public static final String A4SMALL = "a4Small";
	/**
	 * The "a5" page sizes atom.
	 */
	public static final String A5 = "a5";
	/**
	 * The "b4JIS" page sizes atom.
	 */
	public static final String B4JIS = "b4JIS";
	/**
	 * The "b5JIS" page sizes atom.
	 */
	public static final String B5JIS = "b5JIS";
	/**
	 * The "folio" page sizes atom.
	 */
	public static final String FOLIO = "folio";
	/**
	 * The "quarto" page sizes atom.
	 */
	public static final String QUARTO = "quarto";
	/**
	 * The "10By14Inch" page sizes atom.
	 */
	public static final String TENBYFORTEENINCH = "10By14Inch";
	/**
	 * The "11By17Inch" page sizes atom.
	 */
	public static final String ELEVENBYSEVENTEENINCH = "11By17Inch";
	/**
	 * The "note" page sizes atom.
	 */
	public static final String NOTE = "note";
	/**
	 * The "envelope9" page sizes atom.
	 */
	public static final String ENVELOPE9 = "envelope9";
	/**
	 * The "envelope10" page sizes atom.
	 */
	public static final String ENVELOPE10 = "envelope10";
	/**
	 * The "envelope11" page sizes atom.
	 */
	public static final String ENVELOPE11 = "envelope11";
	/**
	 * The "envelope12" page sizes atom.
	 */
	public static final String ENVELOPE12 = "envelope12";
	/**
	 * The "envelope14" page sizes atom.
	 */
	public static final String ENVELOPE14 = "envelope14";
	/**
	 * The "cSizeSheet" page sizes atom.
	 */
	public static final String CSIZESHEET = "cSizeSheet";
	/**
	 * The "dSizeSheet" page sizes atom.
	 */
	public static final String DSIZESHEET = "dSizeSheet";
	/**
	 * The "eSizeSheet" page sizes atom.
	 */
	public static final String ESIZESHEET = "eSizeSheet";
	/**
	 * The "envelopeDL" page sizes atom.
	 */
	public static final String ENVELOPEDL = "envelopeDL";
	/**
	 * The "envelopeC5" page sizes atom.
	 */
	public static final String ENVELOPEC5 = "envelopeC5";
	/**
	 * The "envelopeC3" page sizes atom.
	 */
	public static final String ENVELOPEC3 = "envelopeC3";
	/**
	 * The "envelopeC4" page sizes atom.
	 */
	public static final String ENVELOPEC4 = "envelopeC4";
	/**
	 * The "envelopeC6" page sizes atom.
	 */
	public static final String ENVELOPEC6 = "envelopeC6";
	/**
	 * The "envelopeC65" page sizes atom.
	 */
	public static final String ENVELOPEC65 = "envelopeC65";
	/**
	 * The "envelopeB4" page sizes atom.
	 */
	public static final String ENVELOPEB4 = "envelopeB4";
	/**
	 * The "envelopeB5" page sizes atom.
	 */
	public static final String ENVELOPEB5 = "envelopeB5";
	/**
	 * The "envelopeB6" page sizes atom.
	 */
	public static final String ENVELOPEB6 = "envelopeB6";
	/**
	 * The "envelope" page sizes atom.
	 */
	public static final String ENVELOPE = "envelope";
	/**
	 * The "envelopeMonarch" page sizes atom.
	 */
	public static final String ENVELOPEMONARCH = "envelopeMonarch";
	/**
	 * The "6And3QuartersEnvelope" page sizes atom.
	 */
	public static final String SIXANDTHREEQUARTERSENVELOPE = "6And3QuartersEnvelope";
	/**
	 * The "usStdFanfold" page sizes atom.
	 */
	public static final String USSTDFANFOLD = "usStdFanfold";
	/**
	 * The "germanStdFanfold" page sizes atom.
	 */
	public static final String GERMANSTDFANFOLD = "germanStdFanfold";
	/**
	 * The "germanLegalFanfold" page sizes atom.
	 */
	public static final String GERMANLEGALFANFOLD = "germanLegalFanfold";
	/**
	 * The "b4ISO" page sizes atom.
	 */
	public static final String B4ISO = "b4ISO";
	/**
	 * The "japanesePostcard" page sizes atom.
	 */
	public static final String JAPANESEPOSTCARD = "japanesePostcard";
	/**
	 * The "9By11Inch" page sizes atom.
	 */
	public static final String NINEBYELEVENINCH = "9By11Inch";
	/**
	 * The "10By11Inch" page sizes atom.
	 */
	public static final String TENBYELEVENINCH = "10By11Inch";
	/**
	 * The "15By11Inch" page sizes atom.
	 */
	public static final String FIFTEENBYELEVENINCH = "15By11Inch";
	/**
	 * The "envelopeInvite" page sizes atom.
	 */
	public static final String ENVELOPEINVITE = "envelopeInvite";
	/**
	 * The "letterExtra" page sizes atom.
	 */
	public static final String LETTEREXTRA = "letterExtra";
	/**
	 * The "legalExtra" page sizes atom.
	 */
	public static final String LEGALEXTRA = "legalExtra";
	/**
	 * The "tabloidExtra" page sizes atom.
	 */
	public static final String TABLOIDEXTRA = "tabloidExtra";
	/**
	 * The "a4Extra" page sizes atom.
	 */
	public static final String A4EXTRA = "a4Extra";
	/**
	 * The "letterTransverse" page sizes atom.
	 */
	public static final String LETTERTRANSVERSE = "letterTransverse";
	/**
	 * The "a4Transverse" page sizes atom.
	 */
	public static final String A4TRANSVERSE = "a4Transverse";
	/**
	 * The "letterExtraTransverse" page sizes atom.
	 */
	public static final String LETTEREXTRATRANSVERSE = "letterExtraTransverse";
	/**
	 * The "superASuperAA4" page sizes atom.
	 */
	public static final String SUPERASUPERAA4 = "superASuperAA4";
	/**
	 * The "superBSuperBA3" page sizes atom.
	 */
	public static final String SUPERBSUPERBA3 = "superBSuperBA3";
	/**
	 * The "letterPlus" page sizes atom.
	 */
	public static final String LETTERPLUS = "letterPlus";
	/**
	 * The "a4Plus" page sizes atom.
	 */
	public static final String A4PLUS = "a4Plus";
	/**
	 * The "a5Transverse" page sizes atom.
	 */
	public static final String A5TRANSVERSE = "a5Transverse";
	/**
	 * The "b5JISTransverse" page sizes atom.
	 */
	public static final String B5JISTRANSVERSE = "b5JISTransverse";
	/**
	 * The "a3Extra" page sizes atom.
	 */
	public static final String A3EXTRA = "a3Extra";
	/**
	 * The "a5Extra" page sizes atom.
	 */
	public static final String A5EXTRA = "a5Extra";
	/**
	 * The "b5ISOExtra" page sizes atom.
	 */
	public static final String B5ISOEXTRA = "b5ISOExtra";
	/**
	 * The "a2" page sizes atom.
	 */
	public static final String A2 = "a2";
	/**
	 * The "a3Transverse" page sizes atom.
	 */
	public static final String A3TRANSVERSE = "a3Transverse";
	/**
	 * The "a3ExtraTransverse" page sizes atom.
	 */
	public static final String A3EXTRATRANSVERSE = "a3ExtraTransverse";
	/**
	 * The "TH" role atom.
	 */
	public static final String TH = "TH";
	/**
	 * The "renderCache.bounds" processing instruction atom.
	 */
	public static final String BOUNDS = "renderCache.bounds";
	/**
	 * The "renderCache.textRun" processing instruction atom.
	 */
	public static final String TEXTRUN = "renderCache.textRun";
	/**
	 * The "renderCache.line" processing instruction atom.
	 */
	public static final String LINE = "renderCache.line";
	/**
	 * The "renderCache.subset" processing instruction atom.
	 */
	public static final String SUBSET = "renderCache.subset";
	/**
	 * The "renderCache.macro" processing instruction atom.
	 */
	public static final String MACRO = "renderCache.macro";
	/**
	 * The "renderCache.printPS" processing instruction atom.
	 */
	public static final String PRINTPS = "renderCache.printPS";
	/**
	 * The "renderCache.printPCL" processing instruction atom.
	 */
	public static final String PRINTPCL = "renderCache.printPCL";
	/**
	 * The "renderCache.printZPL" processing instruction atom.
	 */
	public static final String PRINTZPL = "renderCache.printZPL";
	/**
	 * The "originalXFAVersion" processing instruction atom.
	 */
	public static final String ORIGINALXFAVERSION = "originalXFAVersion";
	/**
	 * The "preExecute" script atom.
	 */
	public static final String PREEXECUTE =  	"preExecute";
	/**
	 * The "execute" event/action atom.
	 */
	public static final String EXECUTE =		"execute";
	/**
	 * The "postExecute" event/action atom.
	 */
	public static final String POSTEXECUTE =  	"postExecute";
	/**
	 * The "preOpen" event/action atom.
	 */
	public static final String PREOPEN =		"preOpen";
	/**
	 * The "open" event/action atom.
	 */
	public static final String OPEN =			"open";
	/**
	 * The "postOpen" event/action atom.
	 */
	public static final String POSTOPEN =		"postOpen";
	/**
	 * The "prePrint" event/action atom.
	 */
	public static final String PREPRINT =		"prePrint";
	/**
	 * The "print" event/action atom.
	 */
	public static final String PRINT =			"print";
	/**
	 * The "postPrint" event/action atom.
	 */
	public static final String POSTPRINT =  	"postPrint";
	/**
	 * The "preSave" event/action atom.
	 */
	public static final String PRESAVE =		"preSave";
	/**
	 * The "save" event/action atom.
	 */
	public static final String SAVE =			"save";
	/**
	 * The "postSave" event/action atom.
	 */
	public static final String POSTSAVE =		"postSave";
	/**
	 * The "preSign" event/action atom.
	 */
	public static final String PRESIGN =		"preSign";
	/**
	 * The "sign" event/action atom.
	 */
	public static final String SIGN =			"sign";
	/**
	 * The "postSign" event/action atom.
	 */
	public static final String POSTSIGN =		"postSign";
	/**
	 * The "preSubmit" event/action atom.
	 */
	public static final String PRESUBMIT =  	"preSubmit";
	/**
	 * The "submit" event/action atom.
	 */
	public static final String SUBMIT = 		"submit";
	/**
	 * The "postSubmit" event/action atom.
	 */
	public static final String POSTSUBMIT=  	"postSubmit";
	/**
	 * The "absPage" script atom.
	 */
	public static final String Script_absPage =				"absPage";
	/**
	 * The "absPageCount" script atom.
	 */
	public static final String Script_absPageCount =		"absPageCount";
	/**
	 * The "absPageSpan" script atom.
	 */
	public static final String Script_absPageSpan =			"absPageSpan";
	/**
	 * The "addInstance" script atom.
	 */
	public static final String Script_addInstance =			"addInstance";
	/**
	 * The "addItem" script atom.
	 */
	public static final String Script_addItem =				"addItem";
	/**
	 * The "addNew" script atom.
	 */
	public static final String Script_addNew =				"addNew";
	/**
	 * The "addVar" script atom.
	 */
	public static final String Script_addVar =				"addVar";
	/**
	 * The "aliasNode" script atom.
	 */
	public static final String Script_aliasNode =			"aliasNode";
	/**
	 * The "all" script atom.
	 */
	public static final String Script_all =					"all";
	/**
	 * The "appType" script atom.
	 */
	public static final String Script_appType =				"appType";
	/**
	 * The "append" script atom.
	 */
	public static final String Script_append =				"append";
	/**
	 * The "appendStringToVar" script atom.
	 */
	public static final String Script_appendStringToVar =	"appendStringToVar";
	/**
	 * The "appendVar" script atom.
	 */
	public static final String Script_appendVar =			"appendVar";
	/**
	 * The "applyXSL" script atom.
	 */
	public static final String Script_applyXSL =			"applyXSL";
	/**
	 * The "assignNode" script atom.
	 */
	public static final String Script_assignNode =			"assignNode";
	/**
	 * The "backColor" script atom.
	 */
	public static final String Script_backColor =			"backColor";
	/**
	 * The "beep" script atom.
	 */
	public static final String Script_beep =				"beep";
	/**
	 * The "borderColor" script atom.
	 */
	public static final String Script_borderColor =			"borderColor";
	/**
	 * The "borderWidth" script atom.
	 */
	public static final String Script_borderWidth =			"borderWidth";
	/**
	 * The "boundItem" script atom.
	 */
	public static final String Script_boundItem =			"boundItem";
	/**
	 * The "calculationsEnabled" script atom.
	 */
	public static final String Script_calculationsEnabled =	"calculationsEnabled";
	/**
	 * The "cancel" script atom.
	 */
	public static final String Script_cancel =				"cancel";
	/**
	 * The "cancelAction" script atom.
	 */
	public static final String Script_cancelAction = 		"cancelAction";
	/**
	 * The "cancelBatch" script atom.
	 */
	public static final String Script_cancelBatch =			"cancelBatch";
	/**
	 * The "change" script atom.
	 */
	public static final String Script_change =				"change";
	/**
	 * The "classAll" script atom.
	 */
	public static final String Script_classAll =			"classAll";
	/**
	 * The "classIndex" script atom.
	 */
	public static final String Script_classIndex =			"classIndex";
	/**
	 * The "className" script atom.
	 */
	public static final String Script_className =			"className";
	/**
	 * The "clear" script atom.
	 */
	public static final String Script_clear =				"clear";
	/**
	 * The "clearErrorList" script atom.
	 */
	public static final String Script_clearErrorList =		"clearErrorList";
	/**
	 * The "clearItems" script atom.
	 */
	public static final String Script_clearItems =			"clearItems";
	/**
	 * The "clearVar" script atom.
	 */
	public static final String Script_clearVar =			"clearVar";
	/**
	 * The "clone" script atom.
	 */
	public static final String Script_clone =				"clone";
	/**
	 * The "close" script atom.
	 */
	public static final String Script_close =				"close";
	/**
	 * The "colorToString" script atom.
	 */
	public static final String Script_colorToString =		"colorToString";
	/**
	 * The "commitKey" script atom.
	 */
	public static final String Script_commitKey =			"commitKey";
	/**
	 * The "contains" script atom.
	 */
	public static final String Script_contains =			"contains";
	/**
	 * The "content" script atom.
	 */
	public static final String Script_content =				"content";
	/**
	 * The "contentType" script atom.
	 */
	public static final String Script_contentType =			"contentType";
	/**
	 * The "context" script atom.
	 */
	public static final String Script_context =				"context";
	/**
	 * The "count" script atom.
	 */
	public static final String Script_count =				"count";
	/**
	 * The "createNode" script atom.
	 */
	public static final String Script_createNode =			"createNode";
	/**
	 * The "currentDateTime" script atom.
	 */
	public static final String Script_currentDateTime =		"currentDateTime";
	/**
	 * The "currentPage" script atom.
	 */
	public static final String Script_currentPage =			"currentPage";
	/**
	 * The "currentRecordNumber" script atom.
	 */
	public static final String Script_currentRecordNumber =	"currentRecordNumber";
	/**
	 * The "dataNode" script atom.
	 */
	public static final String Script_dataNode =			"dataNode";
	/**
	 * The "dataWindow" script atom.
	 */
	public static final String Script_dataWindow =			"dataWindow";
	/**
	 * The "delete" script atom.
	 */
	public static final String Script_delete =				"delete";
	/**
	 * The "emit" script atom.
	 */
	public static final String Script_emit =				"emit";
	/**
	 * The "enumerate" script atom.
	 */
	public static final String Script_enumerate =			"enumerate";
	/**
	 * The "execCalculate" script atom.
	 */
	public static final String Script_execCalculate =		"execCalculate";
	/**
	 * The "execEvent" script atom.
	 */
	public static final String Script_execEvent =			"execEvent";
	/**
	 * The "execInitialize" script atom.
	 */
	public static final String Script_execInitialize =		"execInitialize";
	/**
	 * The "execValidate" script atom.
	 */
	public static final String Script_execValidate =		"execValidate";
	/**
	 * The "execute" script atom.
	 */
	public static final String Script_execute =				"execute";
	/**
	 * The "exportData" script atom.
	 */
	public static final String Script_exportData =			"exportData";
	/**
	 * The "file" script atom.
	 */
	public static final String Script_file =				"file";
	/**
	 * The "fillColor" script atom.
	 */
	public static final String Script_fillColor =			"fillColor";
	/**
	 * The "first" script atom.
	 */
	public static final String Script_first =				"first";
	/**
	 * The "fontColor" script atom.
	 */
	public static final String Script_fontColor =			"fontColor";
	/**
	 * The "foreColor" script atom.
	 */
	public static final String Script_foreColor =			"foreColor";
	/**
	 * The "formNodes" script atom.
	 */
	public static final String Script_formNodes =			"formNodes";
	/**
	 * The "formatMessage" script atom.
	 */
	public static final String Script_formatMessage =		"formatMessage";
	/**
	 * The "formattedValue" script atom.
	 */
	public static final String Script_formattedValue =		"formattedValue";
	/**
	 * The "fullText" script atom.
	 */
	public static final String Script_fullText =			"fullText";
	/**
	 * The "getAttribute" script atom.
	 */
	public static final String Script_getAttribute =		"getAttribute";
	/**
	 * The "getElement" script atom.
	 */
	public static final String Script_getElement =			"getElement";
	/**
	 * The "gotoRecord" script atom.
	 */
	public static final String Script_gotoRecord =			"gotoRecord";
	/**
	 * The "gotoURL" script atom.
	 */
	public static final String Script_gotoURL =				"gotoURL";
	/**
	 * The "h" script atom.
	 */
	public static final String Script_h =					"h";
	/**
	 * The "hasDataChanged" script atom.
	 */
	public static final String Script_hasDataChanged =		"hasDataChanged";
	/**
	 * The "id" script atom.
	 */
	public static final String Script_id =					"id";
	/**
	 * The "importData" script atom.
	 */
	public static final String Script_importData =			"importData";
	/**
	 * The "index" script atom.
	 */
	public static final String Script_index =				"index";
	/**
	 * The "insert" script atom.
	 */
	public static final String Script_insert =				"insert";
	/**
	 * The "instanceManager" script atom.
	 */
	public static final String Script_instanceManager =		"instanceManager";
	/**
	 * The "isBOF" script atom.
	 */
	public static final String Script_isBOF =				"isBOF";
	/**
	 * The "isBinary" script atom.
	 */
	public static final String Script_isBinary =			"isBinary";
	/**
	 * The "isCompatibleNS" script atom.
	 */
	public static final String Script_isCompatibleNS =		"isCompatibleNS";
	/**
	 * The "isContainer" script atom.
	 */
	public static final String Script_isContainer =			"isContainer";
	/**
	 * The "isDefined" script atom.
	 */
	public static final String Script_isDefined =			"isDefined";
	/**
	 * The "isEOF" script atom.
	 */
	public static final String Script_isEOF =				"isEOF";
	/**
	 * The "isNull" script atom.
	 */
	public static final String Script_isNull =				"isNull";
	/**
	 * The "isPropertySpecified" script atom.
	 */
	public static final String Script_isPropertySpecified =	"isPropertySpecified";
	/**
	 * The "isRecordGroup" script atom.
	 */
	public static final String Script_isRecordGroup =		"isRecordGroup";
	/**
	 * The "item" script atom.
	 */
	public static final String Script_item =				"item";
	/**
	 * The "keyDown" script atom.
	 */
	public static final String Script_keyDown =				"keyDown";
	/**
	 * The "language" script atom.
	 */
	public static final String Script_language =			"language";
	/**
	 * The "last" script atom.
	 */
	public static final String Script_last =				"last";
	/**
	 * The "length" script atom.
	 */
	public static final String Script_length =				"length";
	/**
	 * The "loadXML" script atom.
	 */
	public static final String Script_loadXML =				"loadXML";
	/**
	 * The "mandatory" script atom.
	 */
	public static final String Script_mandatory =			"mandatory";
	/**
	 * The "mandatoryMessage" script atom.
	 */
	public static final String Script_mandatoryMessage =	"mandatoryMessage";
	/**
	 * The "max" script atom.
	 */
	public static final String Script_max =					"max";
	/**
	 * The "members" script atom.
	 */
	public static final String Script_members =				"members";
	/**
	 * The "message" script atom.
	 */
	public static final String Script_message =				"message";
	/**
	 * The "messageBox" script atom.
	 */
	public static final String Script_messageBox =			"messageBox";
	/**
	 * The "min" script atom.
	 */
	public static final String Script_min =					"min";
	/**
	 * The "model" script atom.
	 */
	public static final String Script_model =				"model";
	/**
	 * The "modifier" script atom.
	 */
	public static final String Script_modifier =			"modifier";
	/**
	 * The "moveCurrentRecord" script atom.
	 */
	public static final String Script_moveCurrentRecord =	"moveCurrentRecord";
	/**
	 * The "moveInstance" script atom.
	 */
	public static final String Script_moveInstance =		"moveInstance";
	/**
	 * The "name" script atom.
	 */
	public static final String Script_name =				"name";
	/**
	 * The "namedItem" script atom.
	 */
	public static final String Script_namedItem =			"namedItem";
	/**
	 * The "newContentType" script atom.
	 */
	public static final String Script_newContentType =		"newContentType";
	/**
	 * The "newText" script atom.
	 */
	public static final String Script_newText =				"newText";
	/**
	 * The "next" script atom.
	 */
	public static final String Script_next =				"next";
	/**
	 * The "nodes" script atom.
	 */
	public static final String Script_nodes =				"nodes";
	/**
	 * The "ns" script atom.
	 */
	public static final String Script_ns =					"ns";
	/**
	 * The "numPages" script atom.
	 */
	public static final String Script_numPages =			"numPages";
	/**
	 * The "occur" script atom.
	 */
	public static final String Script_occur = 				"occur";
	/**
	 * The "oneOfChild" script atom.
	 */
	public static final String Script_oneOfChild =			"oneOfChild";
	/**
	 * The "open" script atom.
	 */
	public static final String Script_open =				"open";
	/**
	 * The "openList" script atom.
	 */
	public static final String Script_openList =			"openList";
	/**
	 * The" page" script atom.
	 */
	public static final String Script_page =				"page";
	/**
	 * The" pageContent" script atom.
	 */
	public static final String Script_pageContent =			"pageContent";
	/**
	 * The" pageCount" script atom.
	 */
	public static final String Script_pageCount =			"pageCount";
	/**
	 * The" pageDown" script atom.
	 */
	public static final String Script_pageDown =			"pageDown";
	/**
	 * The" pageSpan" script atom.
	 */
	public static final String Script_pageSpan =			"pageSpan";
	/**
	 * The" pageUp" script atom.
	 */
	public static final String Script_pageUp =				"pageUp";
	/**
	 * The "parent" script atom.
	 */
	public static final String Script_parent =				"parent";
	/**
	 * The "parentSubform" script atom.
	 */
	public static final String Script_parentSubform =		"parentSubform";
	/**
	 * The "platform" script atom.
	 */
	public static final String Script_platform =			"platform";
	/**
	 * The "prevContentType" script atom.
	 */
	public static final String Script_prevContentType =		"prevContentType";
	/**
	 * The "prevText" script atom.
	 */
	public static final String Script_prevText =			"prevText";
	/**
	 * The "previous" script atom.
	 */
	public static final String Script_previous =			"previous";
	/**
	 * The "print" script atom.
	 */
	public static final String Script_print =				"print";
	/**
	 * The "rawValue" script atom.
	 */
	public static final String Script_rawValue =			"rawValue";
	/**
	 * The "ready" script atom.
	 */
	public static final String Script_ready =				"ready";
	/**
	 * The "recalculate" script atom.
	 */
	public static final String Script_recalculate =			"recalculate";
	/**
	 * The "record" script atom.
	 */
	public static final String Script_record =				"record";
	/**
	 * The "recordsAfter" script atom.
	 */
	public static final String Script_recordsAfter =		"recordsAfter";
	/**
	 * The "recordsBefore" script atom.
	 */
	public static final String Script_recordsBefore =		"recordsBefore";
	/**
	 * The "relayout" script atom.
	 */
	public static final String Script_relayout =			"relayout";
	/**
	 * The "relayoutPageArea" script atom.
	 */
	public static final String Script_relayoutPageArea =	"relayoutPageArea";
	/**
	 * The "remerge" script atom.
	 */
	public static final String Script_remerge =				"remerge";
	/**
	 * The "remove" script atom.
	 */
	public static final String Script_remove =				"remove";
	/**
	 * The "removeAttribute" script atom.
	 */
	public static final String Script_removeAttribute =		"removeAttribute";
	/**
	 * The "removeInstance" script atom.
	 */
	public static final String Script_removeInstance =		"removeInstance";
	/**
	 * The "requery" script atom.
	 */
	public static final String Script_requery =				"requery";
	/**
	 * The "reset" script atom.
	 */
	public static final String Script_reset =				"reset";
	/**
	 * The "resetData" script atom.
	 */
	public static final String Script_resetData =			"resetData";
	/**
	 * The "resolveNode" script atom.
	 */
	public static final String Script_resolveNode =			"resolveNode";
	/**
	 * The "resolveNodes" script atom.
	 */
	public static final String Script_resolveNodes =		"resolveNodes";
	/**
	 * The "response" script atom.
	 */
	public static final String Script_response =			"response";
	/**
	 * The "resync" script atom.
	 */
	public static final String Script_resync =				"resync";
	/**
	 * The "saveXML" script atom.
	 */
	public static final String Script_saveXML =				"saveXML";
	/**
	 * The "selEnd" script atom.
	 */
	public static final String Script_selEnd =				"selEnd";
	/**
	 * The "selStart" script atom.
	 */
	public static final String Script_selStart =			"selStart";
	/**
	 * The "selectedMember" script atom.
	 */
	public static final String Script_selectedMember =		"selectedMember";
	/**
	 * The "setAttribute" script atom.
	 */
	public static final String Script_setAttribute =		"setAttribute";
	/**
	 * The "setElement" script atom.
	 */
	public static final String Script_setElement =			"setElement";
	/**
	 * The "setFocus" script atom.
	 */
	public static final String Script_setFocus =			"setFocus";
	/**
	 * The "setInstances" script atom.
	 */
	public static final String Script_setInstances =		"setInstances";
	/**
	 * The "shift" script atom.
	 */
	public static final String Script_shift =				"shift";
	/**
	 * The "sign" script atom.
	 */
	public static final String Script_sign =				"sign";
	/**
	 * The "soapFaultCode" script atom.
	 */
	public static final String Script_soapFaultCode =		"soapFaultCode";
	/**
	 * The "soapFaultString" script atom.
	 */
	public static final String Script_soapFaultString =		"soapFaultString";
	/**
	 * The "somExpression" script atom.
	 */
	public static final String Script_somExpression =		"somExpression";
	/**
	 * The "stringToColor" script atom.
	 */
	public static final String Script_stringToColor =		"stringToColor";
	/**
	 * The "target" script atom.
	 */
	public static final String Script_target =				"target";
	/**
	 * The "this" script atom.
	 */
	public static final String Script_this =				"this";
	/**
	 * The "timeStamp" script atom.
	 */
	public static final String Script_timeStamp =			"timeStamp";
	/**
	 * The "title" script atom.
	 */
	public static final String Script_title =				"title";
	/**
	 * The "trace" script atom.
	 */
	public static final String Script_trace =				"trace";
	/**
	 * The "traceActivate" script atom.
	 */
	public static final String Script_traceActivate =		"traceActivate";
	/**
	 * The "traceDeactivate" script atom.
	 */
	public static final String Script_traceDeactivate =		"traceDeactivate";
	/**
	 * The "traceEnabled" script atom.
	 */
	public static final String Script_traceEnabled =		"traceEnabled";
	/**
	 * The "update" script atom.
	 */
	public static final String Script_update =				"update";
	/**
	 * The "updateBatch" script atom.
	 */
	public static final String Script_updateBatch =			"updateBatch";
	/**
	 * The "uuid" script atom.
	 */
	public static final String Script_uuid =				"uuid";
	/**
	 * The "validationMessage" script atom.
	 */
	public static final String Script_validationMessage =	"validationMessage";
	/**
	 * The "validationsEnabled" script atom.
	 */
	public static final String Script_validationsEnabled =	"validationsEnabled";
	/**
	 * The "value" script atom.
	 */
	public static final String Script_value =				"value";
	/**
	 * The "varExists" script atom.
	 */
	public static final String Script_varExists =			"varExists";
	/**
	 * The "variation" script atom.
	 */
	public static final String Script_variation =			"variation";
	/**
	 * The "verify" script atom.
	 */
	public static final String Script_verify =				"verify";
	/**
	 * The "version" script atom.
	 */
	public static final String Script_version =				"version";
	/**
	 * The "w" script atom.
	 */
	public static final String Script_w =					"w";
	/**
	 * The "x" script atom.
	 */
	public static final String Script_x =					"x";
	/**
	 * The "y" script atom.
	 */
	public static final String Script_y =					"y";
	/**
	 * The "&quot;" DOM atom.
	 */
	public static final String QUOTES = "'\"";
	/**
	 * The "&lt;" DOM atom.
	 */
	public static final String ELEMENTSTART = "<";
	/**
	 * The "&gt;" DOM atom.
	 */
	public static final String ENDTAG = ">";
	/**
	 * The "/&gt;" DOM atom.
	 */
	public static final String EMPTYELEMENT = "/>";
	/**
	 * The "&lt;/" DOM atom.
	 */
	public static final String CLOSING = "</";
	/**
	 * The "&lt;!--" DOM atom.
	 */
	public static final String COMMENTSTART = "<!--";
	/**
	 * The "--&gt;" DOM atom.
	 */
	public static final String COMMENTEND = "-->";
	/**
	 * The "&lt;!DOCTYPE" DOM atom.
	 */
	public static final String DOCTYPE = "<!DOCTYPE";
	/**
	 * The "&lt;!ENTITY" DOM atom.
	 */
	public static final String ENTITY = "<!ENTITY";
	/**
	 * The "&lt;![CDATA[" DOM atom.
	 */
	public static final String CDATASTART = "<![CDATA[";
	/**
	 * The "]]&gt;" DOM atom.
	 */
	public static final String CDATAEND = "]]>";
	/**
	 * The "&lt;?" DOM atom.
	 */
	public static final String PISTART = "<?";
	/**
	 * The "&lt;?xml" DOM atom.
	 */
	public static final String XMLPISTART = "<?xml";
	/**
	 * The "?&gt;" DOM atom.
	 */
	public static final String PIEND = "?>";
	/**
	 * The "#text" DOM atom.
	 */
	public static final String TEXTNAME = "#text";
	/**
	 * The "#cdata-section" DOM atom.
	 */
	public static final String CDATASECTIONNAME = "#cdata-section";
	/**
	 * The "#comment" DOM atom.
	 */
	public static final String COMMENTNAME = "#comment";
	/**
	 * The "#document" DOM atom.
	 */
	public static final String DOCUMENTNAME = "#document";
	/**
	 * The "#document-fragment" DOM atom.
	 */
	public static final String DOCUMENTFRAGMENTNAME = "#document-fragment";
	/**
	 * The "dummy" DOM atom.
	 */
	public static final String DUMMYELEMENT = "dummy";
	/**
	 * The "file://" DOM atom.
	 */
	public static final String FILEPREFIX = "file://";
	/**
	 * The "href" DOM atom.
	 */
	public static final String STYLEHREF = "href";
	/**
	 * The "SYSTEM" DOM atom.
	 */
	public static final String SYSTEM = "SYSTEM";
	/**
	 * The "text/xsl" DOM atom.
	 */
	public static final String XSLTYPE = "text/xsl";
	/**
	 * The "type" DOM atom.
	 */
	public static final String STYLETYPE = "type";
	/**
	 * The "UTF-8" DOM atom.
	 */
	public static final String UTF8STR = "UTF-8";
	/**
	 * The "xml" DOM atom.
	 */
	public static final String LOWERXMLSTR = "xml";
	/**
	 * The "XML" DOM atom.
	 */
	public static final String UPPERXMLSTR = "XML";
	/**
	 * The "xmlns" DOM atom.
	 */
	public static final String XMLNS = "xmlns";
	/**
	 * The "http://www.w3.org/XML/1998/namespace" DOM atom.
	 */
	public static final String XMLNSURI = "http://www.w3.org/XML/1998/namespace";
	/**
	 * The "xmlns:" DOM atom.
	 */
	public static final String XMLPREFIX = "xmlns:";
	/**
	 * The "xml-stylesheet" DOM atom.
	 */
	public static final String XMLSTYLESHEET = "xml-stylesheet";
	/**
	 * The "KeepOnDisk atom.
	 */
	public static final String KEEPONDISK = "KeepOnDisk";
	/**
	 * The "http://www.w3.org/2000/09/xmldsig#" signature atom.
	 */
	public static final String XMLDSIGNS = "http://www.w3.org/2000/09/xmldsig#";
	/**
	 * The "http://www.w3.org/2002/06/xmldsig-filter2" signature atom.
	 */
	public static final String XMLDSIGXPATHNS = "http://www.w3.org/2002/06/xmldsig-filter2";
	/**
	 * The "Signature" signature atom.
	 */
	public static final String SIGNATURE = "Signature";
	/**
	 * The "SignedInfo" signature atom.
	 */
	public static final String SIGNEDINFO = "SignedInfo";
	/**
	 * The "SignatureProperty" signature atom.
	 */
	public static final String SIGNATUREPROPERTY = "SignatureProperty";
	/**
	 * The "SignatureProperties" signature atom.
	 */
	public static final String SIGNATUREPROPERTIES = "SignatureProperties";
	/**
	 * The "Object" signature atom.
	 */
	public static final String OBJECT = "Object";
	/**
	 * The "CanonicalizationMethod" signature atom.
	 */
	public static final String CANONICALIZATIONMETHOD = "CanonicalizationMethod";
	/**
	 * The "SignatureMethod" signature atom.
	 */
	public static final String SIGNATUREMETHOD = "SignatureMethod";
	/**
	 * The "HMACOutputLength" signature atom.
	 */
	public static final String HMACOUTPUTLENGTH = "HMACOutputLength";
	/**
	 * The "Reference" signature atom.
	 */
	public static final String REFERENCE = "Reference";
	/**
	 * The "URI" signature atom.
	 */
	public static final String URISTR = "URI";
	/**
	 * The "Transforms" signature atom.
	 */
	public static final String TRANSFORMS = "Transforms";
	/**
	 * The "Transform" signature atom.
	 */
	public static final String TRANSFORM = "Transform";
	/**
	 * The "Algorithm" signature atom.
	 */
	public static final String ALGORITHM = "Algorithm";
	/**
	 * The "XPath" signature atom.
	 */
	public static final String XPATH = "XPath";
	/**
	 * The "DigestMethod" signature atom.
	 */
	public static final String DIGESTMETHOD = "DigestMethod";
	/**
	 * The "DigestValue" signature atom.
	 */
	public static final String DIGESTVALUE = "DigestValue";
	/**
	 * The "SignatureValue" signature atom.
	 */
	public static final String SIGNATUREVALUE = "SignatureValue";
	/**
	 * The "id" DOM atom.
	 */
	public static final String LOWERCASEID = "id";

	// CL#724961
	// start exObject atoms corresponding to Flash
	public static final String ExObj_activation = "activation";
	public static final String ExObj_animationStyle = "animationStyle";
	public static final String ExObj_assets = "assets";
	public static final String ExObj_center = "center";
	public static final String ExObj_deactivation = "deactivation";
	public static final String ExObj_defaultHeight = "defaultHeight";
	public static final String ExObj_defaultWidth = "defaultWidth";
	public static final String ExObj_embedded = "embedded";
	public static final String ExObj_explicit = "explicit";
	public static final String ExObj_far = "far";
	public static final String ExObj_flashVars = "flashVars";
	public static final String ExObj_hOffset = "hOffset";
	public static final String ExObj_maxHeight = "maxHeight";
	public static final String ExObj_maxWidth = "maxWidth";
	public static final String ExObj_minHeight = "minHeight";
	public static final String ExObj_minWidth = "minWidth";
	public static final String ExObj_near = "near";
	public static final String ExObj_oscillating = "oscillating";
	public static final String ExObj_pageCurrent = "pageCurrent";
	public static final String ExObj_pageVisible = "pageVisible";
	public static final String ExObj_passContextClick = "passContextClick";
	public static final String ExObj_playCount = "playCount";
	public static final String ExObj_poster = "poster";
	public static final String ExObj_presentationStyle = "presentationStyle";
	public static final String ExObj_speed = "speed";
	public static final String ExObj_swfClassId = "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000";
	public static final String ExObj_transparent = "transparent";
	public static final String ExObj_vOffset = "vOffset";
	public static final String ExObj_windowed = "windowed";
	public static final String ExObj_appShockWaveFlash = "application/x-shockwave-flash";
	// end exObject atoms corresponding to Flash

	/*
	 *  Disallow instances of this class.
	 */
	private STRS() {
	}
	
}
