/*
 * Adobe Confidential
 * ------------------
 * Copyright 2008 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * Notice: all information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and 
 * technical concepts contained herein are proprietary to Adobe Systems Inc.
 * and its suppliers and may be covered by U.S. and foreign patents, patents in 
 * process, and are protected by trade secret or copyright law.  Dissemination 
 * of this information or reproduction of this material is strictly forbidden 
 * unless prior written permission is obtained from Adobe Systems Inc.
 */
package com.adobe.xfa.connectionset.proxies;


import com.adobe.xfa.connectionset.ConnectionSetModel;
import com.adobe.xfa.Element;


/**
 * The ConnectionSetProxy defines a proxy for connectionSets
 * that wish to define an execute action.
 * @exclude from published api.
 */
public abstract class ConnectionSetProxy {

	public ConnectionSetModel moOwner;

	/**
	 * Instantiates a ConnectionSetProxy object.
	 */
	public ConnectionSetProxy() {
		//moOwner = null;
	}

	/**
	 * allow cloning
	 */
	public abstract ConnectionSetProxy clone();

	/**
	 * Virtual method to execute this connection.
	 * @return TRUE if the connection was successfully executed.
	 */
	public abstract boolean execute(Element oWSDLConnectionNode, boolean bDynamicMerge);

	/**
	 * does this Proxy handle a particular connection type?
	 * @return TRUE if this proxy handles the connecitonType.
	 */
	public boolean handlesConnection(int eConnectionTag) {
		return false;
	}
}

