/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import java.io.ByteArrayOutputStream;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.text.Text;

/**
 * <code>SymmetricCrypt</code> provides a symmetric encryption/decryption for
 * storing password in the repository. the encrypted passwords are only thought
 * for "security by obscurity" for example to hide plain text replication
 * password, but everyone that has access to this class can decrypt them.
 *
 * @since 5.3
 * @deprecated since 5.6 Please use granite crypto-support service instead (com.adobe.granite.crypto.CryptoSupport)
 *
 */
public class SymmetricCrypt {

    /**
     * default logger
     */
    private static final Logger log = LoggerFactory.getLogger(SymmetricCrypt.class);

    /**
     * key length
     */
    private final static int KEY_LENGTH = 8;

    /**
     * encryption prefix
     */
    public final static String PREFIX = "{DES}";

    /**
     * Encrypts the given string in a fairly secure way so that it can be
     * {@link #decrypt(String) decrypted} again.
     *
     * @param s string to encrypt
     * @return the encrypted string with a "{AES}" prefix.
     */
    public static String encrypt(String s) {
        try {
            SecretKey key = KeyGenerator.getInstance("DES").generateKey();
            Cipher cipher = Cipher.getInstance("DES");
            byte[] keyBytes = key.getEncoded();
            byte[] data = s.getBytes("utf-8");
            ByteArrayOutputStream out = new ByteArrayOutputStream(keyBytes.length + data.length);
            out.write(keyBytes);
            cipher.init(Cipher.ENCRYPT_MODE, key);
            out.write(cipher.update(data));
            out.write(cipher.doFinal());
            StringBuilder ret = new StringBuilder(PREFIX);
            for (byte b: out.toByteArray()) {
                ret.append(Text.hexTable[b>>4 & 0x0f]).append(Text.hexTable[b&0x0f]);
            }
            return ret.toString();
        } catch (Exception e) {
            log.warn("Unable to encrypt string: " + e);
            return null;
        }
    }

    /**
     * Decrypts a string that was previously {@link #encrypt(String)} encrypted}.
     *
     * @param s the data to decrypt
     * @return the string or <code>null</code> if an internal error occurred
     */
    public static String decrypt(String s) {
        if (!s.startsWith(PREFIX)) {
            return null;
        }
        try {
            byte[] data = new byte[(s.length() - PREFIX.length())/2];
            for (int i=PREFIX.length(),b=0; i<s.length(); i+=2, b++) {
                data[b] = (byte) (Integer.parseInt(s.substring(i, i+2), 16) &0xff);
            }
            SecretKeySpec key = new SecretKeySpec(data, 0, KEY_LENGTH, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
            cipher.init(Cipher.DECRYPT_MODE, key);
            out.write(cipher.update(data, KEY_LENGTH, data.length - KEY_LENGTH));
            out.write(cipher.doFinal());
            return out.toString("utf-8");
        } catch (Exception e) {
            log.warn("Unable to decrypt data: " + e);
            return null;
        }
    }
}