/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.handler;

import java.io.OutputStream;

/**
 * Notification listener that gets invoked when a filter detects start
 * and end markers.
 *
 * @author dpfister
 */
public interface FilterStateListener {

    /**
     * Invoked when the filter detects the start of a section it understands.
     *
     * @param filter filter
     * @return output stream, if the listener wants to have the consecutive
     *         bytes automatically written to some location or <code>null</code>
     */
    public OutputStream started(Filter filter);

    /**
     * Invoked when the filter detects the end of a section.
     *
     * @param filter filter
     * @param out output stream returned from {@link #started(Filter)}
     *            or <code>null</code>
     */
    public void ended(Filter filter, OutputStream out);
}
