/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

/**
 * Value object to contain metadata condition for the IPS API
 */
public class MetadataCondition {
    public MetadataCondition(String fieldHandle, int op, String value) {
        this.fieldHandle = fieldHandle;
        this.op = mapOperation(op);
        this.value = value;
    }

    public String fieldHandle;
    public String op;
    public String value;

    private String mapOperation(int op) {
        switch (op) {
            case EQUALS:
                return "Equals";
            case NOT_EQUALS:
                return "NotEquals";
            case CONTAINS:
                return "Contains";
            case NOT_CONTAINS:
                return "NotContains";
            case STARTS_WITH:
                return "StartsWith";
            case ENDS_WITH:
                return "EndsWith";
        }
        return "";
    }

    // Field Handles
    //
    public static final String ASSET_ID = "asset_id";
    public static final String NAME = "name";
    public static final String FOLDER_PATH = "folder_path";
    public static final String TYPE = "type";
    public static final String FILE_NAME = "file_name";
    public static final String DESCRIPTION = "description";
    public static final String COMMENT = "comment";
    public static final String USER_DATA = "user_data";
    public static final String SKU = "sku";
    public static final String MODIFIED_AT = "modified_at";
    public static final String MODIFIED_BY = "modified_by";
    public static final String CREATED_AT = "created_at";
    public static final String CREATED_BY = "created_by";
    public static final String SUBJECT = "subject";

    // Operations
    //
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 1;
    public static final int CONTAINS = 2;
    public static final int NOT_CONTAINS = 3;
    public static final int STARTS_WITH = 4;
    public static final int ENDS_WITH = 5;
}
