/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ZapfDingbatsEncoding;
import java.util.Iterator;

public final class PDF16PlainTextFormatter {
    private final FallbackFontSet fallbackFontSet;
    public static final InterElementAttribute newComb = new InterElementAttribute("newComb");

    private PDF16PlainTextFormatter(FallbackFontSet fallbackFontSet) {
        this.fallbackFontSet = fallbackFontSet;
    }

    public static PDF16PlainTextFormatter getFormatterInstance(FallbackFontSet fallbackFontSet) {
        return new PDF16PlainTextFormatter(fallbackFontSet);
    }

    public int preFormat(AttributedRun run, int start, int limit) throws FontException, FormattingException {
        limit = InFontFormatter.preFormat(run, start, limit);
        return limit;
    }

    public int format(AttributedRun run, int start, int limit, boolean onComb) throws FontException, FormattingException {
        return this.format(run, start, limit, onComb, true);
    }

    public int format(AttributedRun run, int start, int limit, boolean onComb, boolean shouldKern) throws FontException, FormattingException {
        if (start >= limit) {
            return limit;
        }
        Font desiredFont = (Font)run.getElementStyle(start, ElementAttribute.font);
        if (desiredFont != null) {
            PostscriptFontDescription[] fd = desiredFont.getPostscriptFontDescription();
            for (int i = 0; i < fd.length; ++i) {
                if (!"AdobePiStd".equals(fd[i].getPSName())) continue;
                ZapfDingbatsEncoding.remap(run, start, limit);
                break;
            }
        }
        limit = InFontFormatter.firstPass(run, start, limit);
        ULocale locale = (ULocale)run.getElementStyle(start, ElementAttribute.locale);
        if (desiredFont == null) {
            Iterator it = this.fallbackFontSet.getFallbackFonts(locale);
            desiredFont = it.hasNext() ? (Font)it.next() : Base14.courierRegular;
        }
        FontData desiredFontData = ((FontImpl)desiredFont).getFontData();
        Font tentativeFont = null;
        try {
            int consumed;
            for (int s = start; s < limit; s += consumed) {
                tentativeFont = desiredFont;
                consumed = InFontFormatter.canRenderWithFont(desiredFontData, run, s, limit);
                if (consumed == 0) {
                    Iterator it = this.fallbackFontSet.getFallbackFonts(locale);
                    while (consumed == 0 && it.hasNext()) {
                        tentativeFont = (Font)it.next();
                        consumed = InFontFormatter.canRenderWithFont(((FontImpl)tentativeFont).getFontData(), run, s, limit);
                    }
                }
                if (consumed == 0) {
                    tentativeFont = desiredFont;
                    consumed = InFontFormatter.canRenderWithNotdef(run, s, limit);
                }
                run.setElementStyle(s, s + consumed, ElementAttribute.font, tentativeFont);
            }
        }
        catch (FontException e) {
            e.initFont(tentativeFont);
            throw e;
        }
        if (onComb) {
            run.setInterElementStyleBefore(start, newComb, Boolean.TRUE);
            int graphemeStart = start;
            int i = start + 1;
            while (i < limit) {
                if (!CharUtil.isCombining(run.elementAt(i))) {
                    run.setInterElementStyleBefore(i, newComb, Boolean.TRUE);
                    int newI = InFontFormatter.format(run, graphemeStart, i, shouldKern);
                    limit += newI - i;
                    graphemeStart = newI;
                    i = newI + 1;
                    continue;
                }
                run.setInterElementStyleBefore(i, newComb, Boolean.FALSE);
                ++i;
            }
            return InFontFormatter.format(run, graphemeStart, limit, shouldKern);
        }
        return InFontFormatter.format(run, start, limit, shouldKern);
    }
}

