/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.AFERun;
import com.adobe.xfa.text.DispChange;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.MappingManager;
import com.adobe.xfa.text.PosnStack;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextMarker;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.List;

class FormatInfo {
    static final int COMMIT_OK = 0;
    static final int COMMIT_FULL = 1;
    static final int COMMIT_RETRY = 2;
    private final TextSparseStream mpoStream;
    private final TextDisplay mpoDisplay;
    private final DispChange moChange;
    private final boolean mbUpdate;
    private final AFERun mAFERun;
    private MappingManager mMappingManager;
    private final List<DispTab> moTabs;
    private TextFrame mpoFrame;
    private int mnFrameIndex;
    private int mnStartFrame;
    private int mnSuspectFrameIndex;
    private Storage<DispLineWrapped> mpoLines;
    private int mnOldSize;
    private int mnNewSize;
    private int mnStartLine;
    private int mnNominalStartLine;
    private int mnFirstUnchanged;
    private final PosnStack moPositions = new PosnStack();
    private TextAttr mpoDefaultAttr;
    private TextAttr mpoAttr;
    private int meJustH;
    private int meJustV;
    private boolean mbFirstLine;
    private boolean mbNewPara;
    private boolean mbRTL;
    private UnitSpan moHeight;
    private boolean mbFits;
    private boolean mbUpdateConnect;
    private boolean mbAllInitialLayout;
    private boolean mbStoppedShort;
    private Rect moOldExtent;
    private boolean mbPostLayoutPending;

    FormatInfo(TextDisplay poDisplay, List<DispTab> oTabs, boolean bUpdate, int eJustH, int eJustV, int nSuspectFrameIndex, TextAttr poDefaultAttr) {
        this.mpoStream = poDisplay.stream();
        this.mpoDisplay = poDisplay;
        this.moChange = poDisplay.getChange();
        this.mAFERun = new AFERun(poDisplay.getContext());
        this.moTabs = oTabs;
        this.mnSuspectFrameIndex = nSuspectFrameIndex;
        this.mpoDefaultAttr = poDefaultAttr;
        this.meJustH = eJustH;
        this.meJustV = eJustV;
        this.mbUpdate = bUpdate;
        this.mbFirstLine = true;
        this.mbNewPara = true;
        this.mbRTL = poDisplay.isRTL();
        this.mbFits = true;
        int nFrames = this.mpoStream.getFrameCount();
        this.moPositions.add(new TextPosn());
        if (this.moChange.type() == 0) {
            this.mpoStream.forceFrame(0);
            this.setStartFrame(0);
        }
        if (this.moChange.type() != 0) {
            int nStartLine;
            int i;
            if (this.moChange.type() == 3) {
                this.mbStoppedShort = true;
            }
            if (this.moChange.type() < 6 && this.mbUpdate) {
                TextPosnBase oChangeStart;
                TextDisplay.FindCaretInfo info;
                boolean bFoundStart = false;
                i = nFrames;
                while (i > 0) {
                    TextFrame poFrame;
                    if ((poFrame = this.mpoStream.getFrame(--i)) == null) continue;
                    int nLines = poFrame.getLineCount();
                    if (!poFrame.isInsertAtEnd(this.moChange, nLines - 1)) break;
                    this.setStartFrame(i, nLines - 1, true);
                    bFoundStart = true;
                    break;
                }
                if (!bFoundStart && (info = this.mpoDisplay.findCaretLine(oChangeStart = new TextPosnBase(this.moChange.stream(), this.moChange.index()))) != null) {
                    TextFrame poFrame = this.mpoStream.getFrame(info.mFrameIndex);
                    this.setStartFrame(info.mFrameIndex, info.mLineIndex, poFrame != null && poFrame.isInsertAtEnd(this.moChange, info.mLineIndex));
                }
            } else if (this.moChange.type() == 6 && !this.mbUpdate && nFrames > 0) {
                TextFrame poFrame;
                for (i = 0; i < nFrames && ((poFrame = this.mpoStream.getFrame(i)) == null || poFrame.getLayoutState() != 0); ++i) {
                }
                if (i == nFrames) {
                    this.mbAllInitialLayout = true;
                    return;
                }
                this.setStartFrame(i);
            }
            if (this.mpoFrame == null) {
                this.setStartFrame(0);
            }
            if ((nStartLine = this.getAdjustedStartLine()) > 0 || this.mnFrameIndex > 0) {
                TextPosn oLinePosn = this.getLine(nStartLine).getStartPosition();
                this.moPositions.set(this.moPositions.size() - 1, new TextPosn((TextPosnBase)oLinePosn));
                TextStream poStream = oLinePosn.stream();
                while (poStream != this.mpoStream) {
                    TextPosn poParentPosn = poStream.position();
                    assert (poParentPosn != null);
                    TextPosn oParentNext = poParentPosn;
                    int eNext = oParentNext.next();
                    assert (eNext == 3);
                    this.moPositions.add(0, oParentNext);
                    poStream = oParentNext.stream();
                }
                this.mbFirstLine = false;
            } else {
                this.moPositions.top().associate(this.mpoStream);
            }
            this.setAttr(this.moPositions.top().attributePtr());
        }
        this.preLayout();
    }

    void releaseOldLines() {
        int i;
        for (i = 0; i < this.mnNewSize; ++i) {
            DispLineWrapped poNew = this.getNew(i);
            DispLineWrapped poOld = poNew.getOldLine();
            if (poOld == null) continue;
            poNew.setOldLine(null);
            this.mpoFrame.releaseWrappedLine(poOld);
        }
        for (i = this.mnNewSize; i < this.mnOldSize; ++i) {
            this.mpoFrame.releaseWrappedLine(this.getLine(i));
        }
        this.mpoLines.setSize(this.mnNewSize);
    }

    TextAttr resolveAttr(TextAttr poSource) {
        TextAttr poResult = null;
        if (this.mpoDefaultAttr == null) {
            poResult = poSource;
        } else if (poSource == null) {
            poResult = this.mpoDefaultAttr;
        } else if (poSource.isComplete()) {
            poResult = poSource;
        } else {
            poResult = new TextAttr(poSource);
            poResult.addDisabled(this.mpoDefaultAttr);
        }
        return poResult;
    }

    DispChange getChange() {
        return this.moChange;
    }

    boolean isUpdate() {
        return this.mbUpdate;
    }

    AFERun getAFERun() {
        return this.mAFERun;
    }

    MappingManager getMappingManager() {
        return this.mMappingManager;
    }

    void setMappingManager(MappingManager manager) {
        this.mMappingManager = manager;
    }

    TextFrame getFrame() {
        return this.mpoFrame;
    }

    int getSuspectFrameIndex() {
        return this.mnSuspectFrameIndex;
    }

    TextAttr getAttr() {
        return this.mpoAttr;
    }

    TextAttr getDefaultAttr() {
        return this.mpoDefaultAttr;
    }

    void setAttr(TextAttr poAttr) {
        if (poAttr != null) {
            this.mpoAttr = poAttr;
        }
    }

    int getJustH() {
        return this.meJustH;
    }

    int getJustV() {
        return this.meJustV;
    }

    DispLineWrapped getLine(int nIndex) {
        return (DispLineWrapped)this.mpoLines.get(nIndex);
    }

    int getOldSize() {
        return this.mnOldSize;
    }

    DispLineWrapped getOld(int nIndex) {
        return this.getLine(nIndex).getOldLine();
    }

    int getNewSize() {
        return this.mnNewSize;
    }

    DispLineWrapped getNew(int nIndex) {
        return this.getLine(nIndex);
    }

    DispLineWrapped getLastChanged() {
        return this.getLine(this.mnFirstUnchanged == 0 ? 0 : this.mnFirstUnchanged - 1);
    }

    int getTabSize() {
        return this.moTabs.size();
    }

    DispTab getTab(int nIndex) {
        return this.moTabs.get(nIndex);
    }

    void addTab(DispTab poTab) {
        this.moTabs.add(poTab);
    }

    boolean allInitialLayout() {
        return this.mbAllInitialLayout;
    }

    int getAdjustedStartLine() {
        return this.mnStartLine;
    }

    int commitLine(DispLineWrapped poLine) {
        UnitSpan oNewHeight = this.moHeight.add(poLine.getBExtent());
        if (!this.mpoFrame.allowExtension() && !this.mpoFrame.unlimitedHeight() && this.mnFirstUnchanged > 0) {
            UnitSpan oFrameHeight;
            UnitSpan unitSpan = oFrameHeight = this.mpoFrame.isOrientationHorizontal() ? this.mpoFrame.maxHeight() : this.mpoFrame.maxWidth();
            if (oNewHeight.gt(oFrameHeight)) {
                this.mnNewSize = this.mnFirstUnchanged;
                TextFrame poOldFrame = this.mpoFrame;
                if (!this.advanceFrame()) {
                    return 1;
                }
                if (this.mpoFrame.isOrientationHorizontal() ? !poOldFrame.maxWidth().equals(this.mpoFrame.maxWidth()) && (!poOldFrame.unlimitedWidth() || !this.mpoFrame.unlimitedWidth()) : !poOldFrame.maxHeight().equals(this.mpoFrame.maxHeight()) && (!poOldFrame.unlimitedHeight() || !this.mpoFrame.unlimitedHeight())) {
                    return 2;
                }
                poLine.setFrame(this.mpoFrame);
                oNewHeight = poLine.getBExtent();
            }
        }
        this.moHeight = oNewHeight;
        if (this.mnFirstUnchanged < this.mnOldSize) {
            poLine.setOldLine(this.getLine(this.mnFirstUnchanged));
            this.mpoLines.set(this.mnFirstUnchanged, poLine);
        } else if (!this.mbUpdate && this.mnFirstUnchanged < this.mpoLines.size()) {
            this.mpoLines.set(this.mnFirstUnchanged, poLine);
        } else {
            this.mpoLines.add(poLine);
        }
        ++this.mnFirstUnchanged;
        this.mnNewSize = this.mnFirstUnchanged;
        this.mbFirstLine = false;
        this.mbNewPara = false;
        return 0;
    }

    int getFirstUnchangedIndex() {
        return this.mnFirstUnchanged;
    }

    void finish() {
        this.postLayout();
        if (this.mbUpdate && !this.mbStoppedShort && this.moChange.type() != 0) {
            this.mpoStream.trimFramesOnReflow(this.mnFrameIndex + 1);
        }
        if (!this.mbAllInitialLayout) {
            int nFrame = this.mnStartFrame;
            int nFrameLimit = this.mnFrameIndex;
            if (nFrameLimit < this.mpoStream.getFrameCount()) {
                ++nFrameLimit;
            }
            TextFrame poFrame = this.mpoStream.getFrame(nFrame);
            assert (poFrame != null);
            int nLine = this.getAdjustedStartLine() + 1;
            int nLineLimit = this.mnFirstUnchanged;
            if (nLineLimit > poFrame.getLineCount()) {
                nLineLimit = poFrame.getLineCount();
            }
            ArrayList<TextMarker> oMarkers = new ArrayList<TextMarker>();
            boolean bLayoutSuppressed = false;
            while (true) {
                if (nLine >= nLineLimit) {
                    if (++nFrame >= nFrameLimit) break;
                    poFrame = this.mpoStream.getFrame(nFrame);
                    assert (poFrame != null);
                    nLine = 0;
                    nLineLimit = poFrame.getLineCount();
                }
                DispLineWrapped poLine = poFrame.getLine(nLine);
                TextPosn oSplitPosn = poLine.getStartPosition();
                oSplitPosn.enumerateMarkers(oMarkers, false, true);
                for (int i = 0; i < oMarkers.size(); ++i) {
                    TextRange oRange;
                    TextMarker poMarker = (TextMarker)oMarkers.get(i);
                    assert (poMarker.isRangeMarker());
                    if (poMarker.getSplitState() != 3 || (oRange = poMarker.getRange()).start().index() >= oSplitPosn.index() || oRange.end().index() <= oSplitPosn.index()) continue;
                    poMarker.forceSplit(oSplitPosn.index(), oSplitPosn.index(), 7);
                }
                ++nLine;
            }
            if (bLayoutSuppressed) {
                this.mpoDisplay.popSuppressFormat();
            }
        }
    }

    boolean isFirstLine() {
        return this.mbFirstLine;
    }

    boolean isNewPara() {
        return this.mbNewPara;
    }

    void setNewPara(boolean bNewPara) {
        this.mbNewPara = bNewPara;
    }

    boolean isRTL() {
        return this.mbRTL;
    }

    void setRTL(boolean bRTL) {
        this.mbRTL = bRTL;
    }

    boolean fits() {
        return this.mbFits;
    }

    void setFits(boolean bFits) {
        this.mbFits = bFits;
    }

    boolean updateConnect() {
        return this.mbUpdateConnect;
    }

    void setUpdateConnect(boolean bUpdateConnect) {
        this.mbUpdateConnect = bUpdateConnect;
    }

    PosnStack posnStack() {
        return this.moPositions;
    }

    boolean canStopNow(TextPosnBase oPosn) {
        if (!this.mbUpdate) {
            return false;
        }
        if (this.mnFirstUnchanged <= this.mnNominalStartLine) {
            return false;
        }
        if (this.mnFirstUnchanged >= this.mpoLines.size()) {
            return false;
        }
        if (this.moChange.type() == 3 || this.moChange.type() == 5 || this.moChange.type() == 6 || this.moChange.type() == 7) {
            return false;
        }
        DispLineWrapped poLine = this.getLine(this.mnFirstUnchanged);
        if (poLine.getPositionCount() == 0) {
            return false;
        }
        TextPosn oNextOldPosn = poLine.getPosition(0).pp();
        if (oPosn.stream() == oNextOldPosn.stream() && oPosn.index() == oNextOldPosn.index()) {
            boolean bCanStopNow = false;
            if (this.moChange.type() == 1 || this.moChange.stream() != oPosn.stream()) {
                bCanStopNow = true;
            } else if (this.moChange.type() == 4 || this.moChange.type() == 3) {
                if (this.moChange.index() + this.moChange.count() < oPosn.index()) {
                    bCanStopNow = true;
                }
            } else if (this.moChange.index() < oPosn.index()) {
                bCanStopNow = true;
            }
            if (bCanStopNow) {
                this.mnNewSize = this.mpoLines.size();
                this.mbStoppedShort = true;
                return true;
            }
        }
        return false;
    }

    Rect diff(int nCommonIndex, Rect oDiff) {
        DispLineWrapped poOld = this.getOld(nCommonIndex);
        return poOld == null ? null : this.getNew(nCommonIndex).diff(poOld, oDiff);
    }

    Rect diff(int nOldIndex, int nNewIndex, Rect oDiff) {
        DispLineWrapped poOld = this.getLine(nOldIndex);
        if (poOld.getOldLine() != null) {
            poOld = poOld.getOldLine();
        }
        return this.getNew(nNewIndex).diff(poOld, oDiff);
    }

    Rect diffLast(Rect oDiff) {
        return this.getNew(this.mpoLines.size() - 1).diff(null, oDiff);
    }

    private void setStartFrame(int nFrameIndex, int nLineIndex, boolean bSuppressBackup) {
        int nNominalLineIndex = nLineIndex;
        if (!bSuppressBackup) {
            DispLineWrapped poLine;
            TextFrame poFrame = this.mpoStream.forceFrame(nFrameIndex);
            do {
                if (nLineIndex > 0) {
                    --nLineIndex;
                    continue;
                }
                nNominalLineIndex = 0;
                while (nFrameIndex > 0) {
                    if ((poFrame = this.mpoStream.forceFrame(--nFrameIndex)).getLineCount() <= 0) continue;
                    nNominalLineIndex = poFrame.getLineCount();
                    nLineIndex = nNominalLineIndex - 1;
                    break;
                }
                if (nNominalLineIndex == 0) break;
            } while ((poLine = poFrame.getLine(nLineIndex)).getStartBreak() == 2);
        }
        this.mnStartFrame = nFrameIndex;
        this.attachFrame(nFrameIndex);
        this.setStartLine(nLineIndex, nNominalLineIndex);
    }

    private void setStartFrame(int nFrameIndex) {
        this.setStartFrame(nFrameIndex, 0, false);
    }

    private void setStartLine(int nStartLine) {
        this.setStartLine(nStartLine, nStartLine);
    }

    private void setStartLine(int nStartLine, int nNominalStartLine) {
        DispLineWrapped poLine;
        this.mnStartLine = nStartLine;
        this.mnNominalStartLine = nNominalStartLine;
        this.mnFirstUnchanged = nStartLine;
        if (this.mbUpdate && this.mnFirstUnchanged < this.mpoLines.size()) {
            poLine = this.getLine(this.mnFirstUnchanged);
            this.mbNewPara = poLine.isFirstParaLine();
            this.mbRTL = poLine.isRTL();
        }
        this.moHeight = UnitSpan.ZERO;
        if (this.mpoLines.size() > 0) {
            poLine = this.getLine(this.mnStartLine);
            DispLineWrapped poLine0 = this.getLine(0);
            this.moHeight = poLine.getBMin().subtract(poLine0.getBMin());
        }
    }

    private boolean advanceFrame() {
        this.postLayout();
        if (!this.attachFrame(this.mnFrameIndex + 1)) {
            return false;
        }
        this.setStartLine(0);
        this.preLayout();
        return true;
    }

    private boolean attachFrame(int nFrameIndex) {
        TextFrame poAttachFrame = this.mpoStream.forceFrame(nFrameIndex);
        if (poAttachFrame == null) {
            return false;
        }
        this.mnFrameIndex = nFrameIndex;
        this.mpoFrame = poAttachFrame;
        this.mpoLines = this.mpoFrame.getLines();
        this.mnOldSize = 0;
        this.mnNewSize = 0;
        if (this.mbUpdate) {
            if (this.moChange.type() == 0) {
                this.mnNewSize = this.mpoLines.size();
            } else {
                this.mnOldSize = this.mpoLines.size();
            }
        }
        return true;
    }

    private void preLayout() {
        this.moOldExtent = this.mpoFrame.preLayout(this);
        this.mbPostLayoutPending = true;
    }

    private void postLayout() {
        if (this.mbPostLayoutPending) {
            this.mpoFrame.postLayout(this, this.moOldExtent, false);
        }
        this.mbPostLayoutPending = true;
    }
}

