/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextLayout;
import com.adobe.xfa.text.TextNullFrame;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.ut.Storage;

public abstract class TextSparseStream
extends TextStream {
    private final Storage<TextFrame> moFrames = new Storage();
    private TextContext mpoContext;
    private int meDirection = 0;
    private boolean mbLoadingFrame;

    public TextSparseStream() {
    }

    public TextSparseStream(TextSparseStream oSource) {
        super(oSource);
        this.mpoContext = oSource.mpoContext;
    }

    public TextSparseStream(String sSource) {
        super(sSource);
    }

    public void setContext(TextContext poContext) {
        this.mpoContext = poContext;
    }

    @Override
    public TextContext getContext() {
        return this.mpoContext;
    }

    public void setFrameCount(int nFrames) {
        int nOldSize = this.moFrames.size();
        if (nFrames < nOldSize) {
            this.releaseFrames(nFrames, true);
        } else if (nFrames > nOldSize) {
            this.updateLastLineFlag(false);
            this.moFrames.ensureCapacity(nFrames);
            for (int i = nOldSize; i < nFrames; ++i) {
                this.moFrames.setSize(i + 1);
                this.moFrames.set(i, null);
                this.setFrameAt(i, new TextNullFrame());
            }
        }
    }

    public int getFrameCount() {
        return this.moFrames.size();
    }

    public TextFrame getFrame(int nIndex) {
        return this.getFrame(nIndex, false);
    }

    public TextFrame insertFrame(int nIndex, TextFrame oFrame, TextLayout poLayout) {
        TextFrame poClone = oFrame.cloneFrame();
        this.insertFrameRef(nIndex, poClone, poLayout);
        return poClone;
    }

    public void insertFrameRef(int nIndex, TextFrame poFrame, TextLayout poLayout) {
        if (nIndex >= this.moFrames.size()) {
            this.updateLastLineFlag(false);
        }
        this.moFrames.add(nIndex, null);
        this.setFrameAt(nIndex, poFrame, poLayout);
    }

    public TextFrame appendFrame(TextFrame oFrame, TextLayout poLayout) {
        return this.insertFrame(this.moFrames.size(), oFrame, poLayout);
    }

    public TextFrame appendFrame(TextFrame oFrame) {
        return this.appendFrame(oFrame, null);
    }

    public void appendFrameRef(TextFrame poFrame, TextLayout poLayout) {
        this.insertFrameRef(this.moFrames.size(), poFrame, poLayout);
    }

    public void appendFrameRef(TextFrame oFrame) {
        this.appendFrameRef(oFrame, null);
    }

    public TextFrame setFrame(int nIndex, TextFrame oFrame, TextLayout poLayout) {
        TextFrame poClone = oFrame.cloneFrame();
        this.setFrameRef(nIndex, poClone, poLayout);
        return poClone;
    }

    public void setFrameRef(int nIndex, TextFrame poFrame, TextLayout poLayout) {
        if (nIndex >= this.moFrames.size()) {
            this.setFrameCount(nIndex);
            this.moFrames.setSize(nIndex + 1);
            this.moFrames.set(nIndex, null);
        } else {
            this.releaseFrame(nIndex, true, true, poLayout != null);
        }
        this.setFrameAt(nIndex, poFrame, poLayout);
    }

    public void removeFrame(int nIndex, boolean bRemoveContent) {
        assert (nIndex < this.moFrames.size());
        if (bRemoveContent && nIndex > 0 && nIndex + 1 == this.moFrames.size()) {
            TextFrame poFrame = this.getFrame(nIndex, true);
            TextFrame poPrev = this.getFrame(nIndex - 1);
            if (poFrame != null && poPrev != null) {
                TextPosn oEnd = poFrame.getStart();
                oEnd.tighten(false);
                int[] result = oEnd.prevData(1, true);
                if (result[0] == 5 || result[1] == 10) {
                    oEnd.deleteBack(1);
                }
            }
        }
        this.releaseFrame(nIndex, true, true, bRemoveContent);
        this.moFrames.remove(nIndex);
    }

    public void removeFrame(int nIndex) {
        this.removeFrame(nIndex, false);
    }

    public int defaultDirection() {
        return this.meDirection;
    }

    public void defaultDirection(int eNewDirection) {
        if (eNewDirection == this.defaultDirection()) {
            return;
        }
        this.meDirection = eNewDirection;
        if (this.display() != null) {
            this.display().update();
        }
    }

    public TextDisplay createDisplay() {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            poDisplay = new TextDisplay();
            poDisplay.connectStream(this);
        }
        return poDisplay;
    }

    public abstract TextFrame onLoadFrame(int var1);

    public TextFrame onNewFrame() {
        return null;
    }

    public void onRemoveFrame(int nIndex, boolean bForced, boolean bRemoveContent) {
    }

    public void onFrameRemoved(int nIndex) {
    }

    TextContext forceContext() {
        if (this.mpoContext == null) {
            this.mpoContext = new TextContext();
        }
        return this.mpoContext;
    }

    TextDisplay forceDisplay(TextAttr poDefaultAttr, GFXEnv poGfxEnv) {
        TextDisplay poDisplay = this.display();
        if (poDisplay == null) {
            poDisplay = new TextDisplay();
        }
        poDisplay.connectStream(this, false, poDefaultAttr);
        return poDisplay;
    }

    TextFrame getFrame(int nIndex, boolean bShowNullFrames) {
        TextFrame poResult = (TextFrame)this.moFrames.get(nIndex);
        assert (poResult != null);
        if (!bShowNullFrames && poResult.isNullFrame() != null) {
            return null;
        }
        return poResult;
    }

    public TextFrame forceFrame(int nIndex, boolean bReflow) {
        TextFrame poFrame = null;
        if (nIndex >= this.moFrames.size()) {
            while (nIndex >= this.moFrames.size()) {
                poFrame = this.onNewFrame();
                if (poFrame == null) {
                    return null;
                }
                if (bReflow) {
                    this.appendFrameRef(poFrame);
                    continue;
                }
                this.moFrames.add(poFrame);
                poFrame.setStream(this);
            }
        } else {
            poFrame = this.getFrame(nIndex, true);
            assert (poFrame != null);
            if (poFrame.isNullFrame() != null) {
                poFrame = this.onLoadFrame(nIndex);
                assert (poFrame != null);
            }
        }
        return poFrame;
    }

    public TextFrame forceFrame(int nIndex) {
        return this.forceFrame(nIndex, false);
    }

    void replaceNullFrame(TextNullFrame poNullFrame) {
        int nFrameIndex;
        for (nFrameIndex = 0; nFrameIndex < this.moFrames.size() && this.moFrames.get(nFrameIndex) != poNullFrame; ++nFrameIndex) {
        }
        if (nFrameIndex >= this.moFrames.size()) {
            return;
        }
        this.onLoadFrame(nFrameIndex);
    }

    void trimFramesOnReflow(int nNewSize) {
        if (nNewSize >= this.moFrames.size()) {
            return;
        }
        while (this.moFrames.size() > nNewSize) {
            int nLastIndex = this.moFrames.size() - 1;
            this.releaseFrame(nLastIndex, true, false);
            this.moFrames.setSize(nLastIndex);
        }
        this.updateLastLineFlag(true);
    }

    void updateLastLineFlag(boolean bLastLine, int nLastLineIndex) {
        if (this.moFrames.size() == 0) {
            return;
        }
        TextFrame poFrame = this.getFrame(this.moFrames.size() - 1);
        if (poFrame == null) {
            return;
        }
        int nLines = poFrame.getLineCount();
        if (nLines == 0) {
            return;
        }
        int nLineIndex = nLines - 1;
        if (nLastLineIndex >= 0 && nLastLineIndex < nLineIndex) {
            nLineIndex = nLastLineIndex;
        }
        DispLineWrapped poLine = poFrame.getLine(nLineIndex);
        poLine.setLastLineInStream(bLastLine);
    }

    void updateLastLineFlag(boolean bLastLine) {
        this.updateLastLineFlag(bLastLine, -1);
    }

    protected void populateFrame(int nFrameIndex, TextLayout poLayout) {
        TextPosn oFrameStart = new TextPosn();
        this.setFrameStart(nFrameIndex, oFrameStart);
        this.loadLayout(nFrameIndex, this.getFrame(nFrameIndex, true), poLayout, oFrameStart);
    }

    boolean isLoadingFrame() {
        return this.mbLoadingFrame;
    }

    void setLoadingFrame(boolean bLoadingFrame) {
        this.mbLoadingFrame = bLoadingFrame;
    }

    private void releaseFrames(int nStartIndex, boolean bForced) {
        for (int i = nStartIndex; i < this.moFrames.size(); ++i) {
            this.releaseFrame(i, bForced, bForced, bForced);
        }
        this.moFrames.setSize(nStartIndex);
    }

    private void releaseFrame(int nIndex, boolean bInvokeCallback, boolean bForced, boolean bRemoveContent) {
        TextFrame poFrame = this.getFrame(nIndex, true);
        if (poFrame == null) {
            return;
        }
        TextNullFrame poNullFrame = poFrame.isNullFrame();
        if (poNullFrame != null) {
            poFrame.getStart().removeNullFrame();
        } else {
            if (bInvokeCallback) {
                this.onRemoveFrame(nIndex, bForced, bRemoveContent);
            }
            if (bRemoveContent) {
                this.removeFrameContent(nIndex);
            }
            if (bInvokeCallback) {
                this.onFrameRemoved(nIndex);
            }
        }
        this.moFrames.set(nIndex, null);
        poFrame.setStream(null);
    }

    private void releaseFrame(int nIndex, boolean bInvokeCallback, boolean bForced) {
        this.releaseFrame(nIndex, bInvokeCallback, bForced, false);
    }

    private void removeFrameContent(int nIndex) {
        TextFrame poFrame = this.getFrame(nIndex, true);
        if (poFrame == null) {
            return;
        }
        int nNextFrame = nIndex + 1;
        int nEnd = nNextFrame >= this.moFrames.size() ? Integer.MAX_VALUE : this.getFrame(nNextFrame, true).getStart().index();
        TextRange oRange = new TextRange(this, poFrame.getStart().index(), nEnd);
        if (!oRange.isEmpty()) {
            oRange.delete();
        }
    }

    private void setFrameAt(int nFrameIndex, TextFrame poFrame, TextLayout poLayout) {
        assert (nFrameIndex < this.moFrames.size());
        assert (this.moFrames.get(nFrameIndex) == null);
        poFrame.setStream(this);
        this.moFrames.set(nFrameIndex, poFrame);
        TextPosnBase oStart = new TextPosnBase();
        this.setFrameStart(nFrameIndex, oStart);
        poFrame.setStart(oStart);
        TextPosn oEnd = new TextPosn(oStart);
        oEnd.position(0);
        TextNullFrame poNullFrame = poFrame.isNullFrame();
        if (poNullFrame != null) {
            oStart.insertNullFrame(poNullFrame);
        } else if (poLayout != null) {
            this.loadLayout(nFrameIndex, poFrame, poLayout, oEnd);
        } else {
            oEnd.associate(null);
            if (this.display() != null) {
                this.display().updateToEnd(poFrame.getStart().stream(), poFrame.getStart().index());
            }
        }
        if (oEnd.stream() != null) {
            for (int nNextFrame = nFrameIndex + 1; nNextFrame < this.moFrames.size(); ++nNextFrame) {
                TextFrame poNextFrame = this.getFrame(nNextFrame, true);
                assert (poNextFrame != null);
                if (poNextFrame.getStart() != poFrame.getStart()) break;
                poNextFrame.setStart(oEnd);
            }
        }
    }

    private void setFrameAt(int nIndex, TextFrame poFrame) {
        this.setFrameAt(nIndex, poFrame, null);
    }

    private void setFrameStart(int nFrameIndex, TextPosnBase oFrameStart) {
        int nNextFrame = nFrameIndex + 1;
        if (nNextFrame < this.moFrames.size()) {
            oFrameStart.copyFrom(this.getFrame(nNextFrame, true).getStart());
        } else {
            oFrameStart.associate(this, Integer.MAX_VALUE);
        }
    }

    private void loadLayout(int nIndex, TextFrame poFrame, TextLayout poLayout, TextPosn oEnd) {
        assert (false);
    }
}

