/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.plugins.version.VersionLabelsEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;

class VersionStorageEditor
extends DefaultEditor {
    private static final int VERSION_HISTORY_DEPTH = 6;
    private final NodeBuilder versionStorageNode;
    private final NodeBuilder workspaceRoot;
    private final NodeBuilder builder;
    private final String path;
    private boolean initPhase;
    private ReadWriteVersionManager vMgr;

    VersionStorageEditor(@NotNull NodeBuilder versionStorageNode, @NotNull NodeBuilder workspaceRoot) {
        this(versionStorageNode, workspaceRoot, versionStorageNode, "/jcr:system/jcr:versionStorage", false);
    }

    private VersionStorageEditor(@NotNull NodeBuilder versionStorageNode, @NotNull NodeBuilder workspaceRoot, @NotNull NodeBuilder builder, @NotNull String path, boolean initPhase) {
        this.versionStorageNode = (NodeBuilder)Preconditions.checkNotNull((Object)versionStorageNode);
        this.workspaceRoot = (NodeBuilder)Preconditions.checkNotNull((Object)workspaceRoot);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.initPhase = initPhase;
    }

    @Override
    public void enter(NodeState before, NodeState after) {
        if ("/jcr:system/jcr:versionStorage".equals(this.path)) {
            this.initPhase = VersionStorageEditor.isInitializationPhase(before, after);
        }
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        int d = PathUtils.getDepth(this.path);
        String p = PathUtils.concat(this.path, name);
        if (d == 6 && name.equals("jcr:versionLabels")) {
            return new VersionLabelsEditor(p, this.getVersionManager());
        }
        if (d < 6 && !VersionStorageEditor.isVersionStorageNode(after)) {
            return null;
        }
        return new VersionStorageEditor(this.versionStorageNode, this.workspaceRoot, this.builder.child(name), p, this.initPhase);
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        int d = PathUtils.getDepth(this.path);
        if (d == PathUtils.getDepth("/jcr:system/jcr:versionStorage") && !VersionStorageEditor.isVersionStorageNode(after)) {
            return null;
        }
        if (this.initPhase) {
            return null;
        }
        return this.throwProtected(name);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        int d = PathUtils.getDepth(this.path);
        if (d == 6) {
            this.builder.setChildNode(name, before);
            String relPath = PathUtils.relativize("/jcr:system/jcr:versionStorage", PathUtils.concat(this.path, name));
            this.getVersionManager().removeVersion(relPath);
            return null;
        }
        if (VersionStorageEditor.isVersionStorageNode(before) || d > 6) {
            this.throwProtected(name);
        }
        return null;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (PathUtils.getDepth(this.path) < 6) {
            return;
        }
        this.throwProtected(after.getName());
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (PathUtils.getDepth(this.path) < 6) {
            return;
        }
        this.throwProtected(before.getName());
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (PathUtils.getDepth(this.path) < 6) {
            return;
        }
        this.throwProtected(before.getName());
    }

    private static boolean isVersionStorageNode(NodeState state) {
        String ntName = state.getName("jcr:primaryType");
        return VersionConstants.VERSION_STORE_NT_NAMES.contains(ntName) || VersionConstants.VERSION_NODE_TYPE_NAMES.contains(ntName);
    }

    private ReadWriteVersionManager getVersionManager() {
        if (this.vMgr == null) {
            this.vMgr = new ReadWriteVersionManager(this.versionStorageNode, this.workspaceRoot);
        }
        return this.vMgr;
    }

    private Editor throwProtected(String name) throws CommitFailedException {
        return (Editor)Utils.throwProtected(PathUtils.concat(this.path, name));
    }

    private static boolean isInitializationPhase(NodeState before, NodeState after) {
        return !AbstractNodeState.comparePropertiesAgainstBaseState(after, before, new DefaultNodeStateDiff(){

            @Override
            public boolean propertyAdded(PropertyState after) {
                return !after.getName().equals(":initialized");
            }
        });
    }
}

