/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.repoinit.parser.impl.QuotableStringUtil;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class Operation {
    public static final String DQUOTE = "\"";

    public abstract void accept(OperationVisitor var1);

    protected abstract String getParametersDescription();

    @NotNull
    public abstract String asRepoInitString();

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getParametersDescription();
    }

    public static String cleanupQuotedString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    @NotNull
    static String escapeQuotes(@NotNull String s) {
        String esc = s.replace("\\", "\\\\");
        String escapequotes = esc.replace(DQUOTE, "\\\"");
        return DQUOTE + escapequotes + DQUOTE;
    }

    @NotNull
    static String listToString(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", list);
    }

    @NotNull
    static String pathsToString(@NotNull List<String> paths) {
        return Operation.listToString(paths.stream().map(s -> {
            if (s.startsWith(":") && s.contains("#")) {
                String func = s.substring(1, s.indexOf(":", 1));
                String s2 = s.substring(func.length() + 2, s.lastIndexOf(35));
                if ("authorizable".equals(func)) {
                    s2 = QuotableStringUtil.forRepoInitString((String)s2);
                }
                String trailingPath = s.endsWith("#") ? "" : s.substring(s.indexOf("#") + 1);
                return func + "(" + s2 + ")" + trailingPath;
            }
            return s;
        }).collect(Collectors.toList()));
    }
}

