/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

/**
 * Enumeration that defines the synchronization state of a "slave" variation against the
 * respective element master.
 */
public enum SyncStatus {

    /**
     * Master and "slave" are not synchronized at all
     */
    UNSYNCED,

    /**
     * Master and "slave" are synchronized - they each share the same content state (this
     * could mean both have the same content, or the slave has a "processed" content
     * directly derived from master's current content)
     */
    IN_SYNC,

    /**
     * Master has changed since last synchronization
     */
    MASTER_CHANGED,

    /**
     * "Slave" has changed since last synchronization
     */
    VARIATION_CHANGED,

    /**
     * Both master and "slave" have been changed since last sync ("conflict" state)
     */
    BOTH_CHANGED;

}
