/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.references;

import java.util.List;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * A <code>ReferenceProvider</code> provides {@link Reference}s of a
 * {@link ReferenceList}.
 * Implementations must register themselves as an OSGi-component and declare
 * themselves as a service on this interface.
 * This way the reference aggregator service is able to dynamically use
 * available providers to retrieve references for a given {@link Resource}.
 * References are provided via {@link #getReferences(Resource)}.
 *
 * @since 1.0
 */
@ConsumerType
public interface ReferenceProvider {

    /**
     * Provides a <code>Collection</code> of {@link Reference}s for the given resource.
     *
     * @param resource The {@link Resource} for which to return {@link Reference}s.
     * @return A {@link List} of {@link Reference}s or an empty list if the provider did not find/generate any
     * reference items.
     */
    List<Reference> getReferences(Resource resource);

    /**
     * Returns the type of references this provider provides.
     *
     * @return The type of references this provider provides.
     */
    String getType();

}
