/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * The {@code UserPropertiesFilter} is used to determine whether a given {@link UserProperties} object is included
 * or not.
 */
@ConsumerType
public interface UserPropertiesFilter {

    /**
     * Indicates whether the given {@code userProperties} is included or not.
     *
     * @param userProperties The user properties object to analyze.
     *
     * @return {@code true} if the given user properties shall be included.
     */
    boolean includes(UserProperties userProperties);
}
