/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

/**
 * <code>LinkValidity</code> defines the state of a link in respect to its
 * validity.
 */
public enum LinkValidity {

    /**
     * internal or external link is valid
     */
    VALID,

    /**
     * internal or external link is invalid
     */
    INVALID,

    /**
     * internal link has expired (i.e. offTime in past)
     */
    EXPIRED,

    /**
     * internal link is predated (i.e. onTime in future)
     */
    PREDATED,

    /**
     * external link is pending (not (re)checked yet)
     */
    PENDING
}
