/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.pipeline;

import org.xml.sax.Attributes;

import com.day.cq.rewriter.linkchecker.Link;
import com.day.cq.rewriter.linkchecker.LinkCheckerSettings;

/**
 * The <code>RequestRewriter</code> interface defines an optional
 * service which is used to rewrite attributes.
 * @since 5.4
 */
public interface RequestRewriter {

    /**
     * This method rewrites attributes of an element. If it does not
     * rewrite any attribute of the current element it should just
     * return <code>null</code>.
     * The attributes might be rewritten again by the default link
     * rewriter after they have been rewritten by this service.
     * This method is invoked before the actual link checking takes
     * place; it should therefore not map the links from internal
     * to external representation. That should be done with the
     * {@link #rewriteLink(Link, LinkCheckerSettings)} method.
     *
     * @param elementName the element name
     * @param attributes the attributes of the element
     * @param settings The settings
     * @return The rewritten elements or <code>null</code>
     */
    Attributes rewrite(final String elementName,
                       final Attributes attributes,
                       final LinkCheckerSettings settings);

    /**
     * Rewrite a link and create the external representation.
     * If rewriting is not possible, this method should return <code>null</code>.
     * In this case the default rewriter might rewrite the link.
     * @param link The link
     * @param settings The settings
     * @return The rewritten link or <code>null</code>
     */
    String rewriteLink(final Link link, final LinkCheckerSettings settings);
}
