/*
 * File: Scaler.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;

/** A scaler provides access to font data dependent on a size and target device.
 *
 * The method {@link #setDebugger} can be called at any time. The calls to 
 * the other methods must follow the pattern 
 * (setScale (getOutline | getBitmap)* )*.
 */

public interface Scaler {
  /** Set the scale factor for the font, and describe the target device. */
  public void setScale (double pointSize, double ppemX, double ppemY, double dX, double dY)
  throws InvalidFontException, UnsupportedFontException;

  /** Return the (hinted) outline of a glyph.
   * 
   * Hinting that may be provided by the font is applied. The coordinates
   * are in device space.
   */
  public void getOutline (int gid, OutlineConsumer outlineConsumer)
  throws UnsupportedFontException, InvalidFontException;

  /** Return the bitmap of a glyph.
   * 
   * Hinting that may be provided by the font is applied. The coordinates
   * are in device space.
   */
  public void getBitmap (int gid, BitmapConsumer bitmapConsumer)
  throws UnsupportedFontException, InvalidFontException;
  
  /** Set a debugger to receive details about the computations.
   * 
   * This is used for development purposes only.
   */
  public void setDebugger (ScalerDebugger outlineDebugger);
}
