/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * A builder for creating ConverterResponse objects.
 */
@ProviderType
public interface ConverterResponseBuilder {

    /**
     * Add a specific header with a single value to the response.
     * @param key The header's key.
     * @param value The header's value.
     * @return This ConverterResponseBuilder object.
     */
    @Nonnull
    ConverterResponseBuilder withHeader(String key, String value);

    /**
     * Add a specific header with multiple values to the response.
     * @param key The header's key.
     * @param values The header's values.
     * @return This ConverterResponseBuilder object
     */
    @Nonnull
    ConverterResponseBuilder withHeader(String key, String[] values);

    /**
     * Set the body of the response.  The body should be an instance of CharSequence or a byte[].
     * @param body The body.
     * @return This ConverterResponseBuilder object.
     */
    @Nonnull
    ConverterResponseBuilder setBody(Object body);

    /**
     * Set the content type of the response.
     * @param contentType The content type.
     * @return This ConverterResponseBuilder object.
     */
    @Nonnull
    ConverterResponseBuilder setContentType(String contentType);

    /**
     * Build a ConverterResponse object with the values set in this builder.
     * @return A ConverterResponse.
     */
    @Nonnull
    ConverterResponse build();
}
