/*************************************************************************
  *
  * ADOBE CONFIDENTIAL
  * __________________
  *
  *  Copyright 2012 Adobe Systems Incorporated
  *  All Rights Reserved.
  *
  * NOTICE:  All information contained herein is, and remains
  * the property of Adobe Systems Incorporated and its suppliers,
  * if any.  The intellectual and technical concepts contained
  * herein are proprietary to Adobe Systems Incorporated and its
  * suppliers and may be covered by U.S. and Foreign Patents,
  * patents in process, and are protected by trade secret or copyright law.
  * Dissemination of this information or reproduction of this material
  * is strictly forbidden unless prior written permission is obtained
  * from Adobe Systems Incorporated.
  **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Folder extends AbstractEntity {

    private Folder parent;
    
    private List<Folder> children = new ArrayList<Folder>();

    public Folder(String name, String id) {
       super(name, id);
    }
    
    public Folder(Folder parent, String name, String id) {
        super(name, id);
        this.parent = parent;
    }
    
    public void setParent(Folder parent) {
        this.parent = parent;
    }
    
    public Folder getParent() {
        return parent;
    }
    
    public void add(Folder child) {
        children.add(child);
    }
    
    public void remove(Folder child) {
        children.remove(child);
    }
    
    public Iterator<Folder> getChildren() {
        return children.iterator();
    }

}
