/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.predicate;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

/**
 * Predicate used to filter Folder nodes. Accepts rep:AuthorizableFolder nodes.
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "authorizablefolder")
})
public class IsAuthorizableFolderPredicate extends AbstractNodePredicate implements Predicate {

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is an rep:AuthorizableFolder node.
     */
    public boolean evaluate(Node node) throws RepositoryException {
        return node.isNodeType("rep:AuthorizableFolder");
    }

}