// 
// ========================================================================
// Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
// ------------------------------------------------------------------------
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// and Apache License v2.0 which accompanies this distribution.
// 
// The Eclipse Public License is available at
// http://www.eclipse.org/legal/epl-v10.html
// 
// The Apache License v2.0 is available at
// http://www.opensource.org/licenses/apache2.0.php
// 
// You may elect to redistribute this code under either of these licenses.
// ========================================================================
// 
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

// @deprecated The Eclipse Jetty and Apache Felix Http Jetty packages are no longer supported.
@ManagedObject("Mapped Resource")
@Deprecated(since = "2021-05-27")
public class MappedResource<E> implements Comparable<MappedResource<E>> {

    private final PathSpec pathSpec;

    private final E resource;

    public MappedResource(PathSpec pathSpec, E resource) {
        this.pathSpec = pathSpec;
        this.resource = resource;
    }

    /**
     * Comparison is based solely on the pathSpec
     */
    @Override
    public int compareTo(MappedResource<E> other) {
        return this.pathSpec.compareTo(other.pathSpec);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        MappedResource<?> other = (MappedResource<?>) obj;
        if (pathSpec == null) {
            return other.pathSpec == null;
        } else
            return pathSpec.equals(other.pathSpec);
    }

    @ManagedAttribute(value = "path spec", readonly = true)
    public PathSpec getPathSpec() {
        return pathSpec;
    }

    @ManagedAttribute(value = "resource", readonly = true)
    public E getResource() {
        return resource;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = (prime * result) + ((pathSpec == null) ? 0 : pathSpec.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return String.format("MappedResource[pathSpec=%s,resource=%s]", pathSpec, resource);
    }
}
