/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.inbox.ui;

import aQute.bnd.annotation.ProviderType;

/**
 * The {@code ThumbnailHelper} provides an interface to alter a
 * {@code thumbnail} path.
 * <p>
 * The implementation expects the provided request attribute {@code thumbnail}
 * to match the Regular Expression pattern {@code (.*?)\.thumb\.\d+\.\d+\.(.*)},
 * otherwise the passed in value will be returned. If the pattern matches the
 * {@code width} and {@code height} selectors are replaced by the provided
 * request attributes {@code width} and {@code height}. The default value for
 * the request attributes {@code width} and {@code height} is {@code 319} if
 * omitted.
 */
@ProviderType
public interface ThumbnailHelper {

    /**
     * Returns the altered thumbnail path containing the specified width and
     * height or the original thumbnail path if not applicable.
     * 
     * @return Altered thumbnail path
     */
    String getThumbnail();

}
