/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.adobe.granite.haf.api.ModelPathMapper;
import com.adobe.granite.haf.apiroot.impl.EchoMapper;

/**
 * Defines the Root of a particular category. If this is not defined the default model for the category will be used.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiRoot {
    /**
     * The Sling path to use when creating this resource. This will allow the API framework to inject the correct
     * resource when rendering the Root API response, e.g. /api/category.json
     * @return the base resource path
     */
    public String baseResource();

    /**
     * If paths in the content tree need to changed as they go into the API space implement a ModelPathMapper the
     * converts between the new URL spaces. This allows a developer to have total control over all the paths generated
     * by the API endpoint. Be careful when doing this as it would be easy to create incorrect URLs.
     * @return class that will manage the URL mappings
     */
    public Class<? extends ModelPathMapper> pathMapper() default EchoMapper.class;
}
