/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;

import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A description of an action registered in a model.
 */
@ProviderType
public interface ActionDescription {
    /**
     * Get the HTTP verb the action is registered against.
     * @return The HTTP verb
     */
    @Nonnull
    String getVerb();

    /**
     * Get the name of the action.
     * @return The name of the action.
     */
    @Nonnull
    String getName();

    /**
     * Get the title of the action.
     * @return The title of the action.
     */
    @CheckForNull
    String getTitle();

    /**
     * Get the content type of the request that the action expects.
     * @return The content type of the request.
     */
    @CheckForNull
    String getType();

    /**
     * Get whether the action is considered the default.  Default actions are used to handle requests that cannot be
     * matched to a more specific non-default action registered in the model.  There can be one default action per
     * HTTP verb.
     * @return Whether the action is a default action.
     */
    boolean isDefault();

    /**
     * The resource path the action can be called against.
     * @return The resource path.
     */
    @CheckForNull
    String getResourcePath();

    /**
     * Get the descriptions of the fields the action is expecting.
     * @return The descriptions of the fields.
     */
    @CheckForNull
    Iterable<ActionFieldDescription> getFields();
}
