/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.adobe.xfa.ut.StringUtils;

/**
 * Implements the W3C DOM CharacterData interface.	This class simply
 * stores a text string, and (as per the W3C DOM interface) is the base
 * class for more specific character data holding classes.
 * @exclude from published api.
 */
abstract class CharacterDataImpl extends XFANodeHolder implements CharacterData {
	private final String mData;

	CharacterDataImpl (ParentNode parent, com.adobe.xfa.Node newNode, String data) {
		super (parent, newNode);
		mData = data;
	}

	public void appendData(String arg) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public void deleteData(int offset, int count) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public String getData() throws DOMException {
//		debugReturn ("getData", mData);
		return mData;
	}

	public int getLength() {
//		debugReturn ("getLength", Integer.toString (mData.length()));
		return mData.length();
	}

	public void insertData(int offset, String arg) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public boolean isEqualNode(Node other) {
		if (! (other instanceof CharacterDataImpl)) {
			return false;
		}
		CharacterDataImpl otherCD = (CharacterDataImpl) other;
		return StringUtils.equalsWithNull (mData, otherCD.mData);
	}

	public void replaceData(int offset, int count, String arg) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public void setData(String arg) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public String substringData(int offset, int count) throws DOMException {
		int currentLength = mData.length();
		if ((offset < 0) || (offset >= currentLength) || (count < 0)) {
			throw new DOMException (DOMException.INDEX_SIZE_ERR, "");
		}
		int afterIndex = offset + count;
		if (afterIndex > currentLength) {
			afterIndex = currentLength;
		}
		return mData.substring (offset, afterIndex);
	}

	public String getNodeValue() throws DOMException {
		return mData;
	}

	public String getTextContent() throws DOMException {
		return mData;
	}

	final String getCharacterData () {
		return mData;
	}
}
