/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.Peer;

import java.util.ArrayList;
import java.util.List;

/**
 * @exclude from public api.
 */
public class FormExclGroup extends ExclGroup {
	
	private FormDataListener mDataListener;
	
    private Object mCPDField;
    
	private List<FormListener>	mListenerTable;	// list of listeners
		
	private boolean 	mbValidateRegistered;
		
	private boolean 	mbCalculateRegistered;
	
	/**
	 * @exclude from published api.
	 */
	public void getDeltas(Element delta, XFAList list) {
		
		if (! isSameClass(delta))
			return;

		FormModel model = (FormModel)getModel();
		if (model != null && model.isLoading()) {
			
			// restore validate.disableAll if we are loading
			model.restoreValidateDisableAll(this, delta);
		}
		
		super.getDeltas(delta, list);
	}
	
	/**
	 * Get the data node bound to this Form node
	 * @return The XFA Data node bound to this Form Node
	 */
	public DataNode getDataNode() {
		if (null != getFormDataListener())
			return getFormDataListener().getDataNode();

		return null;
	}
	
	FormExclGroup(Element parent, Node prevSibling) {
		super(parent, prevSibling);
	}

	private FormDataListener getFormDataListener() {
		return mDataListener;
	}

	void setDataNode(DataNode dataNode, boolean bUpdateData, boolean bPeerNode) {
		// remove old listener
		if (mDataListener != null && bPeerNode) {
			mDataListener.dispose();
			mDataListener = null;
		}
		
		if (dataNode == null)
			return;
		
		// Establish a peer relationship with the data node
		if (bPeerNode) 
			mDataListener = new FormDataListener(this, (DataNode)dataNode);

		if (bPeerNode && (null != getFormDataListener()))
			getFormDataListener().deafen();

		if (bUpdateData)
			setData(dataNode);
		else
			setFromData(dataNode);
		
		if (bPeerNode && null != getFormDataListener())
			getFormDataListener().unDeafen();
	}

	void setFromData(DataNode dataNode) {
		if (dataNode == null) {
			dataNode = getDataNode();
		
			if (dataNode == null) 
				return;
		}
		
		if (dataNode.getClassTag() == XFA.DATAVALUETAG) {
			DataNode dataValue = dataNode;
			setRawValue(dataValue.getValue());
		}
	}

	void setData(DataNode dataNode) {
		if (dataNode == null) {
			dataNode = getDataNode();
		
			if (dataNode == null)
				return;
		}

		if (dataNode.getClassTag() != XFA.DATAVALUETAG)
			return;
		
		// if this field is null then set the data node to null;
		if (getIsNull(false)) {
			dataNode.setIsNull(true, true);
			return;
		}
		
		DataNode dataValue = dataNode;		
		dataValue.setValue(getRawValue(), true);
	}
	
	List<FormListener> getFormListeners(boolean bCreate) {
		if (bCreate && mListenerTable == null)
			mListenerTable = new ArrayList<FormListener>();
		
		return mListenerTable;
	}

	// clean up the data and datalistener
	void cleanupListeners() {
		if (mDataListener != null) {
			mDataListener.dispose();
			mDataListener = null;
		}

		if (mListenerTable != null) {
			mListenerTable.clear();
			mListenerTable = null;
		}
	}

	/**
	 * @see Element#getIsNull()
	 */
	public boolean getIsNull() {
		return getIsNull(true);
	}
	
	private boolean getIsNull(boolean bCheckData) {
		NodeList /* <Field> */ children = getMembers();
		if (children == null)
			return true;
		
		// watson bug 1759877, check the data node for the null state (same way we do for fields).
		DataNode dataNode = getDataNode();
		if (bCheckData && dataNode != null && dataNode.getClassTag() == XFA.DATAVALUETAG)
			return dataNode.getIsNull();

		// look through the members to see if any have been filled
		for (int i = 0; i < children.length(); i++) {
			if (!((Field)children.item(i)).getIsNull())
				return false;
		}

		return true;
	}

	public void execEvent(String sActivity) {
		FormModel formModel = (FormModel)getModel();
		formModel.eventOccurred(sActivity, this);
	}

	public boolean execValidate() {
		FormModel formModel = (FormModel)getModel();
		FormModel.Validate validate = formModel.getDefaultValidate();

		formModel.validate(validate, this, true, false);
			
		if (validate!= null && validate.getFailCount() > 0)
			return false;
		
		return true;	
	}

	/**
	 * @exclude from published api.
	 */
	public Object getCPDField() {
	    return mCPDField;
	}
	
	/**
	 * For use by Gibson for XFAplugins.
	 * @exclude from published api.
	 */
	public void	setCPDField(Object oCPDField) {
	    mCPDField = oCPDField;
	}

    public boolean getRegistered(int eActivity) {
        if (eActivity == XFA.VALIDATETAG)
            return mbValidateRegistered;
        else if (eActivity == XFA.CALCULATETAG)
            return mbCalculateRegistered;
        return false;
    }

	void setRegistered(int eActivity) {
		if (eActivity == XFA.VALIDATETAG)
			mbValidateRegistered = true;
		else if (eActivity == XFA.CALCULATETAG)
		    mbCalculateRegistered = true;
	}

	/**
	 * @exclude from public api.
	 */
	public void notifyPeers(int eventType,
				     String arg1,
   				     Object arg2) {
		
		// XFA doesn't notify of changes during loads, there is no need and it improves load performance		
		if (getModel() != null && getModel().isLoading())
			return;

		// If validate changes at run time and there are no validations  
		// registered for this node, then we need to register it so that validations
		// will fire.
		if (!mbValidateRegistered && arg2 instanceof FormModel.Validate) {
			FormModel formModel = (FormModel)getModel();
			formModel.registerEvents(this, FormModel.XFAEVENTTYPE_VALIDATE);
		}
		else if (eventType == Peer.DESCENDENT_VALUE_CHANGED &&
			arg2 instanceof Content) {
			Node node = ((Content)arg2).getXFAParent();
			
			while (!(node instanceof Container))
				node = node.getXFAParent();
			
			if (node instanceof FormField) {
				FormField field = (FormField)node;

				String sValue = field.getRawValue();
				
				// if the field is On then make sure that all the other 
				// radioButtons are turned off
				String sOnValue = field.getOnValue();
				if (sOnValue != null && sOnValue.equals(sValue)) {
					NodeList members = getMembers();
					int nChildren = members.length();
					for (int i = 0; i < nChildren; i++) {
						Field field2 = (Field)members.item(i);
					
						sOnValue = field2.getOnValue();
						if (sOnValue != null && !sOnValue.equals(sValue))
							field2.setOn(false);					
					}
				}
			}
		}
		
		super.notifyPeers(eventType, arg1, arg2);
	}
}
