package com.adobe.xfa.text.markup;

/**
 * @exclude from published api.
 */

public class MarkupXHTMLAttr extends MarkupAttr {
	public static final MarkupXHTMLAttr DEFAULT_ATTR = new MarkupXHTMLAttr();

	MarkupXHTMLAttr () {
		InitializeMap();
	}

	public boolean isFontNameSpecifier (String oStrCommand) {
		return false;
	}

	public static MarkupXHTMLAttr getDefault () {
		return DEFAULT_ATTR;
	}

	public char blockPrefix () {
		return '\0';
	}

	public char blockSuffix () {
		return '\0';
	}

	public char commandPrefix () {
		return '\0';
	}

	public boolean isDelimiter (char c) {
		return (c != '*')				// Notation in newer command support
			&& (c != '-')				// Used for negative numeric parameters
			&& (c != '\'')				// Used for specifying hex characters
			&& (c != '\"')				// Quote
			&& ((c < 'a') || (c > 'z'))	// XHTML commands are ALWAYS lower case
			&& ((c < 'A') || (c > 'Z'))	// Free form text may have upper case
			&& ((c < '0') || (c > '9'));
	}

	public char disablingChar () {
		return '0';
	}

	public char delimiter () {
		return '\0';
	}

	public int pointSizeFactor () {
		return 2;						 // Half point increments
	}

	public boolean isValidMarkup (String sXHTML) {
		return (sXHTML.contains("xmlns=\"http://www.w3.org/1999/xhtml\""))
			|| (sXHTML.contains("xmlns='http://www.w3.org/1999/xhtml'"));
	}

	public String whiteSpace () {
		return "\t\n\f\r \u8203";
	}

	private void InitializeMap () {
// General keywords
		setEntry (MARKUP_ALL, "all");
		setEntry (MARKUP_AUTO, "auto");
		setEntry (MARKUP_NONE, "none");
		setEntry (MARKUP_NORMAL, "normal");
		setEntry (MARKUP_SOLID, "solid");

// paragraph
		setEntry (MARKUP_PARAGRAPH_START, "p");
		setEntry (MARKUP_BREAK, "br");

// Special Characters
		setEntry (MARKUP_SPAN, "span");
		setEntry (MARKUP_ANCHOR, "a");
		setEntry (MARKUP_LINE_HEIGHT, "line-height:");
		setEntry (MARKUP_STYLE, "style");
		setEntry (MARKUP_DIV, "div");

// we may need to change this to use full namespace instead of prefix
// when XML_SetReturnNSTriplet is used
		setEntry (MARKUP_EMBED, "embed");
		setEntry (MARKUP_EMBEDMODE, "embedMode");
		setEntry (MARKUP_EMBEDTYPE, "embedType");

		setEntry (MARKUP_BODY, "body");
		setEntry (MARKUP_HTML, "html");

		setEntry (MARKUP_SPACE_RUN, "xfa-spacerun:");
		setEntry (MARKUP_SPACE_RUN_NO, "no");
		setEntry (MARKUP_SPACE_RUN_YES, "yes");

// indentation
		setEntry (MARKUP_INDENT_FIRST_LINE, "text-indent:", true);
		setEntry (MARKUP_INDENT_LEFT, "margin-left:", true);
		setEntry (MARKUP_INDENT_RIGHT, "margin-right:", true);
		setEntry (MARKUP_SPACE_BEFORE, "margin-top:", true);
		setEntry (MARKUP_SPACE_AFTER, "margin-bottom:", true);
		setEntry (MARKUP_MARGIN, "margin:", true);

// units
		setEntry (MARKUP_CM, "cm");
		setEntry (MARKUP_PT, "pt");
		setEntry (MARKUP_INCHES, "in");
		setEntry (MARKUP_MM, "mm");

// font
		setEntry (MARKUP_FONT_NAME, "font-family:", true);
		setEntry (MARKUP_FONT_SIZE, "font-size:", true);
		setEntry (MARKUP_FONT_WEIGHT, "font-weight:", true);
		setEntry (MARKUP_FONT_STYLE, "font-style:", true);
		setEntry (MARKUP_FONT, "font:", true);
		setEntry (MARKUP_FONT_BOLD, "bold");
		setEntry (MARKUP_FONT_ITALIC, "italic");
		setEntry (MARKUP_FONT_HORIZONTAL_SCALE, "xfa-font-horizontal-scale");
		setEntry (MARKUP_FONT_VERTICAL_SCALE, "xfa-font-vertical-scale");
//		setEntry (MARKUP_FONT_SPREAD, "font-spread");	// TODO: needs to be removed from C++ implementation
		setEntry (MARKUP_COLOUR, "color:");

// effects
		setEntry (MARKUP_BOLD, "b");
		setEntry (MARKUP_ITALIC, "i");
		setEntry (MARKUP_SUPER, "sup");
		setEntry (MARKUP_SUB, "sub");
		setEntry (MARKUP_UNDERLINE_TAG, "u");
		setEntry (MARKUP_UNDERLINE, "underline");
		setEntry (MARKUP_STRIKEOUT, "line-through");
		setEntry (MARKUP_UNDERLINE_DOUBLE, "double");
		setEntry (MARKUP_UNDERLINE_WORD, "word");
		setEntry (MARKUP_UNDERLINE_ALL, "continuous");
		setEntry (MARKUP_TEXT_UNDERLINE, "text-underline:");
		setEntry (MARKUP_TEXT_UNDERLINE_STYLE, "text-underline-style:");
		setEntry (MARKUP_TEXT_UNDERLINE_MODE, "text-underline-mode:");
		setEntry (MARKUP_TEXT_DECORATION, "text-decoration:");
		setEntry (MARKUP_BASELINE, "baseline");

// justification
		setEntry (MARKUP_JUSTIFY, "text-align:");
		setEntry (MARKUP_JUSTIFY_SPREAD, "justify");
		setEntry (MARKUP_JUSTIFY_SPREAD_ALL, "justify-all");
		setEntry (MARKUP_JUSTIFY_COMB_LEFT, "comb-left");
		setEntry (MARKUP_JUSTIFY_COMB_CENTER, "comb-center");
		setEntry (MARKUP_JUSTIFY_COMB_RIGHT, "comb-right");

		setEntry (MARKUP_JUSTIFY_VERT, "vertical-align:");
		setEntry (MARKUP_TEXT_VALIGN, "text-valign:");
		setEntry (MARKUP_TEXT_VALIGN_TOP, "top");
		setEntry (MARKUP_TEXT_VALIGN_MIDDLE, "middle");
		setEntry (MARKUP_TEXT_VALIGN_BOTTOM, "bottom");

// tabs
		setEntry (MARKUP_TAB_DEFAULT, "tab-interval:");
		setEntry (MARKUP_TAB_POSITION, "tab-stops:", true);
		setEntry (MARKUP_TAB_ALIGN_DECIMAL, "decimal");
		setEntry (MARKUP_TAB_COUNT, "xfa-tab-count:");

// XHTML keywords
		setEntry (MARKUP_XHTML_LEFT, "left");
		setEntry (MARKUP_XHTML_CENTER, "center");
		setEntry (MARKUP_XHTML_RIGHT, "right");

// digits
		setEntry (MARKUP_DIGITS, "xfa-digits:");
		setEntry (MARKUP_DIGITS_DEFAULT, "default");
		setEntry (MARKUP_DIGITS_ARABIC, "arabic");
		setEntry (MARKUP_DIGITS_INDIC, "indic");

// neutral character direction
		setEntry (MARKUP_DIRECTION, "dir");
		setEntry (MARKUP_DIRECTION_LTR, "ltr");
		setEntry (MARKUP_DIRECTION_RTL, "rtl");

// ligature level
		setEntry (MARKUP_LIGATURE, "xfa-ligatures:");
		setEntry (MARKUP_LIGATURE_MINIMUM, "minimal");
		setEntry (MARKUP_LIGATURE_COMMON, "common");

// spacing
		setEntry (MARKUP_CHAR_SPACING, "letter-spacing:");
		setEntry (MARKUP_WORD_SPACING, "word-spacing:");

// hyphenation
		setEntry (MARKUP_HYPHENATION, "hyphenation:");
		setEntry (MARKUP_HYPHENATION_ACRONYMS, "xfa-hyphenation-acronyms:");
		setEntry (MARKUP_HYPHENATION_LENGTH, "xfa-hyphenation-length:");
		setEntry (MARKUP_HYPHENATION_LEVEL, "xfa-hyphenation-level:");
		setEntry (MARKUP_HYPHENATION_NAMES, "xfa-hyphenation-names:");
		setEntry (MARKUP_HYPHENATION_PREFERRED, "preferred");

// kerning
		setEntry (MARKUP_KERNING_MODE, "kerning-mode:");
		setEntry (MARKUP_KERN_PAIR, "pair");

// leaders
		setEntry (MARKUP_LEADER_ALIGN, "leader-align:", true);
		setEntry (MARKUP_LEADER_ALIGN_PAGE, "page");
		setEntry (MARKUP_LEADER_PATTERN, "leader-pattern:", true);
		setEntry (MARKUP_LEADER_PATTERN_SPACE, "space");
		setEntry (MARKUP_LEADER_PATTERN_RULE, "rule");
		setEntry (MARKUP_LEADER_PATTERN_DOTS, "dots");
		setEntry (MARKUP_LEADER_PATTERN_USE_CONTENT, "use-content");
		setEntry (MARKUP_LEADER_PATTERN_USE_CONTENT2, "useContent");
		setEntry (MARKUP_LEADER_PATTERN_WIDTH, "leader-pattern-width:", true);
		setEntry (MARKUP_RULE_STYLE, "rule-style:", true);
		setEntry (MARKUP_RULE_STYLE_DOTTED, "dotted");
		setEntry (MARKUP_RULE_STYLE_DASHED, "dashed");
		setEntry (MARKUP_RULE_THICKNESS, "rule-thickness:", true);
	}
}
