/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

import java.util.UUID;

/**
 * @exclude from published api.
 */
public final class UuidFactory {
	
	private static boolean gbTestMode = false;
	
	private static ThreadLocal<Long> timeLowCounter = new ThreadLocal<Long>() {
        protected Long initialValue() {
            return Long.valueOf(0xFFEE);
        }
    };
	
	private static ThreadLocal<Long> timeMidCounter = new ThreadLocal<Long>() {
        protected Long initialValue() {
            return Long.valueOf(0xB0B0);
        }
    };
	
	private static ThreadLocal<Long> timeHighCounter = new ThreadLocal<Long>() {
        protected Long initialValue() {
            return Long.valueOf(0xA0A0);
        }
    };

    private static long incr(ThreadLocal<Long> oCounter) {
        long lVal = (oCounter.get()).longValue();
        oCounter.set(Long.valueOf(lVal + 1));
        return lVal;
    }
    
	private UuidFactory() {
	}
	
	public static void setTestMode(boolean bTestMode) {
		gbTestMode = bTestMode;
	}
	
	public static String getUuid() {
		UUID uuid;
		if (gbTestMode) {
			long low = incr(timeLowCounter);
			long mid = incr(timeMidCounter);
			long time_hi_and_ver = incr(timeHighCounter);
			uuid = new UUID((low << 32) | (mid << 16) | time_hi_and_ver, 0);
		}
		else {
			uuid = UUID.randomUUID();
		}
		return uuid.toString();
	}

}
