/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.contentfinder;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Hit implements Comparable<Hit> {
    private Map<String, Object> map = new HashMap<String, Object>();

    public Object get(String name) {
        return map.get(name);
    }

    public void set(String name, Object value) {
        map.put(name, value);
    }
    
    public Iterator<String> getKeys() {
        return map.keySet().iterator();
    }

    public int compareTo(Hit other) {
        long lastModified = getLastModified(this);
        long otherLastModified = getLastModified(other);
        if (lastModified < otherLastModified) {
            return -1;
        } else if (lastModified > otherLastModified) {
            return 1;
        }
        // compare path
        String path = getPath(this);
        String otherPath = getPath(other);
        return path.compareTo(otherPath);
    }

    private static long getLastModified(Hit hit) {
        Object cal = hit.get("lastModified");
        if (cal instanceof Calendar) {
            return ((Calendar) cal).getTimeInMillis();
        }
        return 0;
    }

    private static String getPath(Hit hit) {
        Object path = hit.get("path");
        if (path instanceof String) {
            return (String) path;
        }
        return "";
    }
}
